# Повторное использование строкового литерала (DuplicateStringLiteral)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги      |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:-------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `1`                 | `badpractice` |

## Параметры


|          Имя          |   Тип    |                              Описание                              |    Значение<br>по умолчанию    |
|:---------------------:|:--------:|:------------------------------------------------------------------:|:------------------------------:|
| `allowedNumberCopies` | `Целое`  | `Допустимое количество повторов использования строкового литерала` |              `2`               |
|     `analyzeFile`     | `Булево` |                 `Анализировать весь файл целиком`                  |            `false`             |
|    `caseSensitive`    | `Булево` |                        `Учитывать регистр`                         |            `false`             |
|    `minTextLength`    | `Целое`  |       `Минимальная длина строкового литерала (с кавычками)`        |              `5`               |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Многократное использование одинаковых строковых литералов в одном модуле или методе является плохим тоном, т.к. 
- оно может приводить к сложностям при дальнейшем сопровождении, когда необходимо изменить значение и высока вероятность пропустить одно из повторений
- оно может быть следствием "копипасты", т.е. разработчик забыл изменить, после копирования похожего блока кода.

### Особенности реализации диагностики

- Диагностика с настройками по умолчанию не учитывает регистр символов литерала, т.о. считаются одинаковыми строки `АААА` и `АааА`.
- Нельзя указать минимальное значение анализируемого литерала меньше, чем значение по умолчанию. Это обусловлено тем, что часто используются служебные литералы, которые будут сильно фонить. Например: пустая строка "", числа-селекторы "1", "0" и т.д.
- Нельзя уменьшить допустимое количество повторов использования меньше 1, т.к. это не имеет практического смысла. 

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Плохой код

```bsl
Процедура Тест(Параметр)
    Результат = "Значение";
    Если Параметр = "ВРег" Тогда
        Результат = Результат + ВРег("Значение");
    Иначе
        Результат = Результат + HРег("Значение");
    КонецЕсли; 
КонецПроцедуры
```

Исправленный вариант

```bsl
Процедура Тест(Параметр)
    Результат = "Значение";
    Если Параметр = "ВРег" Тогда
        Результат = Результат + ВРег(Результат);
    Иначе
        Результат = Результат + HРег(Результат);
    КонецЕсли; 
КонецПроцедуры
```

Плохой код

```bsl
Процедура Тест2(Параметр)
    Если Параметр = "ВРег" Тогда
        Результат = Результат + ВРег("Значение");
    Иначе
        Результат = Результат + HРег("Значение");
    КонецЕсли; 
КонецПроцедуры

Процедура Тест3(Параметр)
    Если Параметр = "СОКРЛП" Тогда
        Результат = Результат + СокрЛП("Значение");
    КонецЕсли; 
КонецПроцедуры
```

Исправленный вариант

```bsl
Процедура Тест2(Параметр)
    Если Параметр = "ВРег" Тогда
        Результат = Результат + ВРег(СтроковоеЗначение());
    Иначе
        Результат = Результат + HРег(СтроковоеЗначение());
    КонецЕсли; 
КонецПроцедуры

Процедура Тест3(Параметр)
    Если Параметр = "СОКРЛП" Тогда
        Результат = Результат + СокрЛП(СтроковоеЗначение());
    КонецЕсли; 
КонецПроцедуры

Функция СтроковоеЗначение() 
    Возврат "Значение"; 
КонецПроцедуры
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:DuplicateStringLiteral-off
// BSLLS:DuplicateStringLiteral-on
```

### Параметр конфигурационного файла

```json
"DuplicateStringLiteral": {
    "allowedNumberCopies": 2,
    "analyzeFile": false,
    "caseSensitive": false,
    "minTextLength": 5
}
```
