# Функция должна содержать возврат (FunctionShouldHaveReturn)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                 Теги                  |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-------------------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                `10`                 |    `suspicious`<br>`unpredictable`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

`Функция` отличается от `Процедуры` только тем, что обязательно возвращает значение и может быть использована в выражениях.

Исходя из описанного выше утверждения, `функция` не содержащая возврата, сама по себе является ошибочной. Необходимо внести исправления

- реализовать возврат значения, если реализованный метод все-таки является функцией
- переписать функцию на процедуру, если возврат значения не предусматривается

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:FunctionShouldHaveReturn-off
// BSLLS:FunctionShouldHaveReturn-on
```

### Параметр конфигурационного файла

```json
"FunctionShouldHaveReturn": false
```
