# Пропущен обязательный параметр метода (MissedRequiredParameter)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |  Теги   |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `1`                 | `error` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

При вызове функций не следует пропускать обязательные параметры. В противном случае в параметр будет передано значение `Неопределено`, на которое функция может быть не рассчитана.
Если же значение `Неопределено` является допустимым, то нужно
- или его передавать в функцию явно
- или сделать этот параметр необязательным со значением по умолчанию `Неопределено`.
## Примеры

Например, для вызова процедуры

```bsl
Процедура ПоменятьЦветПоляФормы(Форма, ИмяПоля, Цвет)
```

неправильно:

```bsl
ПоменятьЦветПоляФормы(,"РезультатПроверки", ЦветаСтиля.ПоясняющийОшибкуТекст); // пропущен первый параметр Форма
ПоменятьЦветПоляФормы(,,); // пропущены все обязательные параметры
```

правильно:

```bsl
ПоменятьЦветПоляФормы(ЭтотОбъект, "РезультатПроверки", Цвет); // указаны все обязательные параметры
```

## Источники

[Параметры процедур и функций](https://its.1c.ru/db/v8std#content:640:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissedRequiredParameter-off
// BSLLS:MissedRequiredParameter-on
```

### Параметр конфигурационного файла

```json
"MissedRequiredParameter": false
```
