# Обращение к отсутствующему методу общего модуля (MissingCommonModuleMethod)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |  Теги   |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:-------:|
| `Ошибка` |             `BSL`             | `Блокирующий` |              `Да`              |                 `5`                 | `error` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Правило регистрирует ошибочные обращения к методам общих модулей.
Находятся проблемные варианты
- когда метода нет в указанном общем модуле
- когда метод есть в общем модуле, но метод не является экспортным
- когда у общего модуля отсутствуют исходники, все обращения к любым его методам помечаются как ошибочные

Исключаются варианты
- когда имя переменной совпадает с именем общего модуля
## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissingCommonModuleMethod-off
// BSLLS:MissingCommonModuleMethod-on
```

### Параметр конфигурационного файла

```json
"MissingCommonModuleMethod": false
```
