# Избыточное использование "Ссылка" в запросе (RefOveruse)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |             Теги             |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:----------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |    `sql`<br>`performance`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Использование ".Ссылка" к полю ссылочного типа приведет к неявному левому соединению с таблицей-источником данного поля, 
при этом не несет никакой ценности, а только генерирует избыточную нагрузку на СУБД.
## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```bsl
Запрос.Текст = "ВЫБРАТЬ Файлы.Файл.Ссылка, // ошибка
   | Файлы.Файл
   | ИЗ
   | СлужебныеФайлы КАК Файлы";
```
## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
* Полезная информация: [Разыменование ссылочных полей составного типа в языке запросов](https://its.1c.ru/db/v8std/content/654/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:RefOveruse-off
// BSLLS:RefOveruse-on
```

### Параметр конфигурационного файла

```json
"RefOveruse": false
```
