# Обработчик регламентного задания (ScheduledJobHandler)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |  Теги   |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:-------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                 `5`                 | `error` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
К обработчикам регламентных заданий предъявляются определенные требования.
В качестве метода регламентного задания может выступать любая экспортная процедура или функция неглобального общего серверного модуля. Если методом регламентного задания является функция, то ее возвращаемое значение игнорируется.

Если регламентное задание является предопределенным, то у его обработчика не должно быть параметров.
Если нет, тогда параметрами подобного регламентного задания могут быть любые значения, которые разрешено передавать на сервер. Параметры регламентного задания должны в точности соответствовать параметрам той процедуры или функции, которую оно вызывает.

Правило проверяет следующие признаки валидности метода-обработчика регламентного задания:
- существует и общий модуль и метод общего модуля, указанные как обработчик
- общий модуль является серверным
- метод является экспортным
- у метода нет параметров, если регламентное задание является предопределенным.
- задано тело метода
- нет двух и более регламентных заданий, которые ссылаются на один и тот же метод-обработчик

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
- [Набор статей "Регламентные задания" - стандарт 1С ](https://its.1c.ru/db/v8std#browse:13:-1:1:6)
- [Статья "Регламентные задания" из руководства разработчика 1С 8.3](https://its.1c.ru/db/v8322doc#bookmark:dev:TI000000794)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:ScheduledJobHandler-off
// BSLLS:ScheduledJobHandler-on
```

### Параметр конфигурационного файла

```json
"ScheduledJobHandler": false
```
