# Выражение должно заканчиваться символом ";" (SemicolonPresence)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `1`                 |    `standard`<br>`badpractice`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

В текстах программных процедур и функций операторы между собой обязательно стоит разделять точкой с запятой (";"). Конец строки не является признаком конца оператора.
Не смотря на то, что в некоторых случаях платформа позволяет опускать точку с запятой, необходимо указывать этот символ всегда, явно указывая завершение оператора.

**ПРИМЕЧАНИЕ**: Ключевые слова `Процедура`, `КонецПроцедуры`, `Функция`, `КонецФункции` являются не операторами, а операторными скобками, поэтому **НЕ** должны заканчиваться точкой с запятой (это может приводить к ошибкам выполнения модуля).

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:SemicolonPresence-off
// BSLLS:SemicolonPresence-on
```

### Параметр конфигурационного файла

```json
"SemicolonPresence": false
```
