# Использование методов "НайтиПоНаименованию", "НайтиПоКоду" и "НайтиПоНомеру" (UsingFindElementByString)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                           Теги                           |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:--------------------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `2`                 |       `standard`<br>`badpractice`<br>`performance`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Правило находит использование методов `НайтиПоНаименованию`, `НайтиПоКоду` или `НайтиПоНомеру` с указанием конкретных и
уникальных номеров, кодов и названий элементов или документов.
Скорее всего, подобный код не будет работать в других ИБ, что приведет к ошибкам выполнения.
Возможно, в финальный код попал тестовый код, что также не рекомендовано.

Константные значения данных из ИБ рекомендуется указывать в константах ИБ, предопределенных элементах метаданных.

## Примеры

Неправильно:
```bsl
Должность = Справочники.Должности.НайтиПоНаименованию("Ведущий бухгалтер");
```
или
```bsl
Должность = Справочники.Должности.НайтиПоКоду("00-0000001");
```

или

```bsl
ОбъектНазначения = Документы.ПередачаТоваровМеждуОрганизациями.НайтиПоНомеру("0000-000001", ТекущаяДата());
```

Допустимо использование:
```bsl
Справочники.Валюты.НайтиПоКоду(ТекущиеДанные.КодВалютыЦифровой);
```
```bsl
Справочники.КлассификаторБанков.НайтиПоКоду(СведенияОБанке.БИК);
```

```bsl
Документы.Реализация.НайтиПоНомеру(НомерДокумента);
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingFindElementByString-off
// BSLLS:UsingFindElementByString-on
```

### Параметр конфигурационного файла

```json
"UsingFindElementByString": false
```
