# Обращение к виртуальной таблице без параметров (VirtualTableCallWithoutParameters)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                       Теги                       |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------:|
| `Ошибка` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |       `sql`<br>`standard`<br>`performance`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При использовании виртуальных таблиц в запросах, следует передавать в параметры таблиц все условия, относящиеся к данной виртуальной таблице. 

Не рекомендуется обращаться к виртуальным таблицам при помощи условий в секции ГДЕ и т.п.

Такой запрос будет возвращать правильный (с точки зрения функциональности) результат, но СУБД будет намного сложнее выбрать оптимальный план для его выполнения. В некоторых случаях это может привести к ошибкам оптимизатора СУБД и значительному замедлению работы запроса.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
Например, следующий запрос использует секцию `ГДЕ` запроса для выборки из виртуальной таблицы:
```bsl
Запрос.Текст = "ВЫБРАТЬ
| Номенклатура
|ИЗ
| РегистрНакопления.ТоварыНаСкладах.Остатки()
|ГДЕ
| Склад = &Склад";
```
Возможно, что в результате выполнения этого запроса сначала будут выбраны все записи виртуальной таблицы, а затем из них будет отобрана часть, соответствующая заданному условию.

Рекомендуется ограничивать количество выбираемых записей на самом раннем этапе обработки запроса. Для этого следует передать условия в параметры виртуальной таблицы. 

```bsl
Запрос.Текст = "ВЫБРАТЬ
| Номенклатура
|ИЗ
| РегистрНакопления.ТоварыНаСкладах.Остатки(, Склад = &Склад)";
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* Источник: [Стандарт: Обращения к виртуальным таблицам](https://its.1c.ru/db/v8std#content:657:hdoc)
* Источник: [Стандарт: Эффективное обращение к виртуальной таблице «Остатки»](https://its.1c.ru/db/v8std#content:733:hdoc)
* Источник: [Рекомендация 1С: Использование параметра Условие при обращении к виртуальной таблице](https://its.1c.ru/db/metod8dev/content/5457/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:VirtualTableCallWithoutParameters-off
// BSLLS:VirtualTableCallWithoutParameters-on
```

### Параметр конфигурационного файла

```json
"VirtualTableCallWithoutParameters": false
```
