# Некорректное использование метода ОтменитьТранзакцию() (WrongUseOfRollbackTransactionMethod)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                 `1`                 | `standard` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Вызов метода ОтменитьТранзакцию должен производиться в блоке Попытка-Исключение. 
В блоке Исключение нужно сначала вызвать метод ОтменитьТранзакцию, а затем выполнять другие действия, если они требуются.
## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```bsl
НачатьТранзакцию();
Попытка
    ДокументОбъект.Записать();
    ЗафиксироватьТранзакцию();
Исключение
    ЗаписьЖурналаРегистрации(НСтр("ru = 'Выполнение операции'"),
        УровеньЖурналаРегистрации.Ошибка,
        ,
        ,
        ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));

    ОтменитьТранзакцию(); // Срабатывание здесь

    ВызватьИсключение; // есть внешняя транзакция

КонецПопытки;
```
## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

Источник: [Стандарт: Транзакции: правила использования](https://its.1c.ru/db/v8std#content:783:hdoc:_top)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:WrongUseOfRollbackTransactionMethod-off
// BSLLS:WrongUseOfRollbackTransactionMethod-on
```

### Параметр конфигурационного файла

```json
"WrongUseOfRollbackTransactionMethod": false
```
