/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop;

import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sentry.Sentry;
import io.sentry.protocol.SentryId;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

@Aspect
public class SentryAspect {
    private ExecutorService executorService;
    @CheckForNull
    private LanguageClientHolder languageClientHolder;
    private Resources resources;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ SentryAspect ajc$perSingletonInstance;

    @PostConstruct
    private void init() {
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("sentry-"));
    }

    @PreDestroy
    private void onDestroy() {
        this.executorService.shutdown();
    }

    @AfterThrowing(value="Pointcuts.isBSLDiagnostic() && Pointcuts.isGetDiagnosticsCall()", throwing="ex")
    public void logThrowingBSLDiagnosticGetDiagnostics(Throwable ex) {
        this.logException(ex);
    }

    @AfterThrowing(value="Pointcuts.isPublicMethodCall() && (Pointcuts.isLanguageServer() || Pointcuts.isTextDocumentService() || Pointcuts.isWorkspaceService())", throwing="ex")
    public void logThrowingLSPCall(Throwable ex) {
        this.logException(ex);
    }

    private void logException(Throwable ex) {
        CompletableFuture.runAsync(() -> {
            SentryId sentryId = Sentry.captureException((Throwable)ex);
            if (sentryId.equals((Object)SentryId.EMPTY_ID)) {
                return;
            }
            if (this.languageClientHolder == null) {
                return;
            }
            MessageType messageType = MessageType.Info;
            String message = this.resources.getResourceString(this.getClass(), "logMessage", sentryId);
            MessageParams messageParams = new MessageParams(messageType, message);
            this.languageClientHolder.execIfConnected(languageClient -> languageClient.showMessage(messageParams));
        }, this.executorService);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SentryAspect() {
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLanguageClientHolder(@CheckForNull LanguageClientHolder languageClientHolder) {
        this.languageClientHolder = languageClientHolder;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public static SentryAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.github._1c_syntax.bsl.languageserver.aop.SentryAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            SentryAspect.ajc$perSingletonInstance = new SentryAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

