/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop.measures;

import com.github._1c_syntax.bsl.languageserver.aop.measures.ConditionalOnMeasuresEnabled;
import com.github._1c_syntax.bsl.languageserver.utils.ThrowingSupplier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMeasuresEnabled
public class MeasureCollector {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MeasureCollector.class);
    private final Map<String, List<Long>> measures = new ConcurrentHashMap<String, List<Long>>();

    public Object measureIt(ThrowingSupplier<?> supplier, String measureType) {
        long startDI = System.currentTimeMillis();
        Object result = supplier.get();
        long endDI = System.currentTimeMillis();
        this.measures.computeIfAbsent(measureType, s -> new CopyOnWriteArrayList()).add(endDI - startDI);
        return result;
    }

    public void printMeasures() {
        this.measures.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((List)entry.getValue()).stream().mapToLong(value -> value).sum())).sorted(Comparator.comparingLong(Map.Entry::getValue)).map(entry -> String.format("%s - %d", entry.getKey(), entry.getValue())).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MeasureCollector() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, List<Long>> getMeasures() {
        return this.measures;
    }
}

