/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop.sentry;

import com.github._1c_syntax.bsl.languageserver.aop.sentry.PermissionFilterBeforeSendCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.protocol.User;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.lsp4j.ServerInfo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SentryScopeConfigurer {
    private final ServerInfo serverInfo;
    private final PermissionFilterBeforeSendCallback beforeSendCallback;
    @Value(value="${sentry.dsn:}")
    private final String dsn;
    @Value(value="${sentry.environment:dummy}")
    private final String environment;

    @PostConstruct
    public void init() {
        if (this.dsn != null && !this.dsn.isEmpty()) {
            Sentry.init(options -> {
                options.setDsn(this.dsn);
                options.setEnvironment(this.environment);
                options.setRelease(this.serverInfo.getVersion());
                options.setAttachServerName(false);
                options.setServerName(this.getServerName());
                options.setBeforeSend((SentryOptions.BeforeSendCallback)this.beforeSendCallback);
                options.addInAppInclude("com.github._1c_syntax.bsl.languageserver");
            });
        }
        Sentry.configureScope(scope -> {
            User user = new User();
            user.setId(UUID.randomUUID().toString());
            scope.setUser(user);
        });
    }

    @Nullable
    private String getServerName() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            return UUID.nameUUIDFromBytes(hostName.getBytes()).toString();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @ConstructorProperties(value={"serverInfo", "beforeSendCallback", "dsn", "environment"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SentryScopeConfigurer(ServerInfo serverInfo, PermissionFilterBeforeSendCallback beforeSendCallback, @Value(value="${sentry.dsn:}") String dsn, @Value(value="${sentry.environment:dummy}") String environment) {
        this.serverInfo = serverInfo;
        this.beforeSendCallback = beforeSendCallback;
        this.dsn = dsn;
        this.environment = environment;
    }
}

