/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cfg;

import com.github._1c_syntax.bsl.languageserver.cfg.BasicBlockVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.BranchingVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdge;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdgeType;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ConditionalVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ControlFlowGraph;
import com.github._1c_syntax.bsl.languageserver.cfg.ExitVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ForLoopVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ForeachLoopVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.LabelVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.LoopVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.TryExceptVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.WhileLoopVertex;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCfgVisitor {
    private static final Map<Class<? extends CfgVertex>, VertexVisitor> dispatchVertexFunctions = AbstractCfgVisitor.createVertexDispatch();
    private static final Map<CfgEdgeType, EdgeVisitor> dispatchEdgeFunctions = AbstractCfgVisitor.createEdgeDispatch();
    protected final ControlFlowGraph graph;

    private static Map<Class<? extends CfgVertex>, VertexVisitor> createVertexDispatch() {
        HashMap<Class<? extends CfgVertex>, VertexVisitor> map = new HashMap<Class<? extends CfgVertex>, VertexVisitor>();
        map.put(BasicBlockVertex.class, (t, v) -> t.visitBasicBlock((BasicBlockVertex)v));
        map.put(ConditionalVertex.class, (t, v) -> t.visitConditionalVertex((ConditionalVertex)v));
        map.put(WhileLoopVertex.class, (t, v) -> t.visitWhileLoopVertex((WhileLoopVertex)v));
        map.put(ForLoopVertex.class, (t, v) -> t.visitForLoopVertex((ForLoopVertex)v));
        map.put(ForeachLoopVertex.class, (t, v) -> t.visitForeachLoopVertex((ForeachLoopVertex)v));
        map.put(TryExceptVertex.class, (t, v) -> t.visitTryExceptVertex((TryExceptVertex)v));
        map.put(LabelVertex.class, (t, v) -> t.visitLabelVertex((LabelVertex)v));
        map.put(ExitVertex.class, (t, v) -> t.visitExitVertex((ExitVertex)v));
        return map;
    }

    private static Map<CfgEdgeType, EdgeVisitor> createEdgeDispatch() {
        EnumMap<CfgEdgeType, EdgeVisitor> map = new EnumMap<CfgEdgeType, EdgeVisitor>(CfgEdgeType.class);
        map.put(CfgEdgeType.DIRECT, AbstractCfgVisitor::visitDirectEdge);
        map.put(CfgEdgeType.TRUE_BRANCH, AbstractCfgVisitor::visitTrueEdge);
        map.put(CfgEdgeType.FALSE_BRANCH, AbstractCfgVisitor::visitFalseEdge);
        map.put(CfgEdgeType.LOOP_ITERATION, AbstractCfgVisitor::visitLoopIterationEdge);
        return map;
    }

    protected AbstractCfgVisitor(ControlFlowGraph graph) {
        this.graph = graph;
    }

    public void visitVertex(CfgVertex v) {
        if (v instanceof BranchingVertex) {
            this.visitSuperclassingVertexType((BranchingVertex)v);
            return;
        }
        this.dispatchVertex(v);
    }

    protected void visitBasicBlock(BasicBlockVertex v) {
        this.dispatchRoutes(v);
    }

    protected void visitBranchingVertex(BranchingVertex v) {
        this.dispatchVertex(v);
    }

    protected void visitLoopVertex(LoopVertex v) {
        this.dispatchVertex(v);
    }

    protected void visitConditionalVertex(ConditionalVertex v) {
        this.dispatchRoutes(v);
    }

    protected void visitWhileLoopVertex(WhileLoopVertex v) {
        this.dispatchRoutes(v);
    }

    protected void visitForLoopVertex(ForLoopVertex v) {
        this.dispatchRoutes(v);
    }

    protected void visitForeachLoopVertex(ForeachLoopVertex v) {
        this.dispatchRoutes(v);
    }

    protected void visitLabelVertex(LabelVertex v) {
        this.dispatchRoutes(v);
    }

    protected void visitTryExceptVertex(TryExceptVertex v) {
        this.dispatchRoutes(v);
    }

    protected void visitExitVertex(ExitVertex v) {
        this.dispatchRoutes(v);
    }

    protected boolean visitDirectEdge(CfgEdge e) {
        return true;
    }

    protected boolean visitTrueEdge(CfgEdge e) {
        return true;
    }

    protected boolean visitFalseEdge(CfgEdge e) {
        return true;
    }

    protected boolean visitLoopIterationEdge(CfgEdge e) {
        return false;
    }

    private void dispatchRoutes(CfgVertex v) {
        Set routes = this.graph.outgoingEdgesOf(v);
        for (CfgEdge route : routes) {
            EdgeVisitor router = dispatchEdgeFunctions.get((Object)route.getType());
            boolean shouldFollow = router.invoke(this, route);
            if (!shouldFollow) continue;
            CfgVertex target = (CfgVertex)this.graph.getEdgeTarget((Object)route);
            this.visitVertex(target);
        }
    }

    protected final void dispatchVertex(CfgVertex v) {
        VertexVisitor dispatch = dispatchVertexFunctions.get(v.getClass());
        if (dispatch == null) {
            throw new IllegalStateException();
        }
        dispatch.invoke(this, v);
    }

    private void visitSuperclassingVertexType(BranchingVertex v) {
        if (v instanceof LoopVertex) {
            this.visitLoopVertex((LoopVertex)v);
        } else {
            this.visitBranchingVertex(v);
        }
    }

    @FunctionalInterface
    private static interface VertexVisitor {
        public void invoke(AbstractCfgVisitor var1, CfgVertex var2);
    }

    @FunctionalInterface
    private static interface EdgeVisitor {
        public boolean invoke(AbstractCfgVisitor var1, CfgEdge var2);
    }
}

