/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.codeactions.CodeActionSupplier;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import com.github._1c_syntax.bsl.languageserver.utils.Strings;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.springframework.stereotype.Component;

@Component
public class ExtractStructureConstructorSupplier
implements CodeActionSupplier {
    private final LanguageServerConfiguration configuration;

    @Override
    public List<CodeAction> getCodeActions(CodeActionParams params, DocumentContext documentContext) {
        Position start = params.getRange().getStart();
        if (start == null) {
            return Collections.emptyList();
        }
        BSLParser.FileContext parseTree = documentContext.getAst();
        Optional<BSLParser.DoCallContext> maybeDoCall = Trees.findTerminalNodeContainsPosition((BSLParserRuleContext)parseTree, start).map(TerminalNode::getParent).filter(BSLParser.TypeNameContext.class::isInstance).map(BSLParser.TypeNameContext.class::cast).filter(DiagnosticHelper::isStructureType).map(BSLParserRuleContext::getParent).map(BSLParser.NewExpressionContext.class::cast).map(BSLParser.NewExpressionContext::doCall);
        if (maybeDoCall.isEmpty()) {
            return Collections.emptyList();
        }
        List<BSLParser.CallParamContext> parameters = maybeDoCall.map(BSLParser.DoCallContext::callParamList).map(callParamListContext -> callParamListContext.children).orElse(Collections.emptyList()).stream().filter(Predicate.not(TerminalNode.class::isInstance)).map(BSLParser.CallParamContext.class::cast).toList();
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        BSLParser.CallParamContext firstParam = parameters.get(0);
        if (firstParam.getTokens().isEmpty()) {
            return Collections.emptyList();
        }
        Token firstToken = (Token)firstParam.getTokens().get(0);
        if (firstToken.getType() != 37) {
            return Collections.emptyList();
        }
        BSLParser.DoCallContext doCall = maybeDoCall.get();
        BSLParser.AssignmentContext assignment = (BSLParser.AssignmentContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)doCall, 81);
        if (assignment == null || ExtractStructureConstructorSupplier.isParentAssignment(doCall, assignment)) {
            return Collections.emptyList();
        }
        BSLParser.LValueContext lValue = assignment.lValue();
        if (lValue == null) {
            return Collections.emptyList();
        }
        String lValueName = lValue.getText();
        String insert = Resources.getResourceString(this.configuration.getLanguage(), this.getClass(), "insert");
        String[] keys = Strings.trimQuotes(firstToken.getText()).split(",");
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        ArrayList<TextEdit> changes = new ArrayList<TextEdit>();
        TextEdit constructorEdit = new TextEdit(Ranges.create((ParserRuleContext)doCall), "()");
        changes.add(constructorEdit);
        int indentSize = Ranges.create((ParserRuleContext)lValue).getStart().getCharacter();
        Range rparenRange = Ranges.create(doCall.RPAREN());
        int constructorLine = rparenRange.getEnd().getLine();
        Position position = new Position(constructorLine + 1, 0);
        Range range = new Range(position, position);
        String indent = documentContext.getContentList()[constructorLine].substring(0, indentSize);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i].trim();
            String value = "";
            String separator = "";
            if (parameters.size() > i + 1) {
                value = parameters.get(i + 1).getText();
                separator = ", ";
            }
            String newText = String.format("%s%s.%s(\"%s\"%s%s);\n", indent, lValueName, insert, key, separator, value);
            TextEdit textEdit = new TextEdit(range, newText);
            changes.add(textEdit);
        }
        workspaceEdit.setChanges(Map.of(documentContext.getUri().toString(), changes));
        CodeAction codeAction = new CodeAction();
        codeAction.setEdit(workspaceEdit);
        codeAction.setKind("refactor");
        codeAction.setIsPreferred(Boolean.TRUE);
        codeAction.setTitle(Resources.getResourceString(this.configuration.getLanguage(), this.getClass(), "title"));
        return Collections.singletonList(codeAction);
    }

    private static boolean isParentAssignment(BSLParser.DoCallContext doCall, BSLParser.AssignmentContext assignment) {
        return assignment.expression().member().stream().map(BSLParser.MemberContext::complexIdentifier).map(BSLParser.ComplexIdentifierContext::newExpression).filter(newExpressionContext -> newExpressionContext == doCall.getParent()).findAny().isEmpty();
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExtractStructureConstructorSupplier(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

