/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.codeactions.AbstractQuickFixSupplier;
import com.github._1c_syntax.bsl.languageserver.codeactions.QuickFixSupplier;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

@Component
public class FixAllCodeActionSupplier
extends AbstractQuickFixSupplier {
    private static final int ADD_FIX_ALL_DIAGNOSTICS_THRESHOLD = 2;

    public FixAllCodeActionSupplier(QuickFixSupplier quickFixSupplier) {
        super(quickFixSupplier);
    }

    @Override
    protected Stream<CodeAction> processDiagnosticStream(Stream<Diagnostic> diagnosticStream, CodeActionParams params, DocumentContext documentContext) {
        return diagnosticStream.map(Diagnostic::getCode).distinct().flatMap(diagnosticCode -> this.getFixAllCodeAction((Either<String, Integer>)diagnosticCode, params, documentContext).stream());
    }

    private List<CodeAction> getFixAllCodeAction(Either<String, Integer> diagnosticCode, CodeActionParams params, DocumentContext documentContext) {
        Optional<Class<QuickFixProvider>> quickFixClass = this.quickFixSupplier.getQuickFixClass(diagnosticCode);
        if (quickFixClass.isEmpty()) {
            return Collections.emptyList();
        }
        List<Diagnostic> suitableDiagnostics = documentContext.getComputedDiagnostics().stream().filter(diagnostic -> diagnosticCode.equals((Object)diagnostic.getCode())).collect(Collectors.toList());
        if (suitableDiagnostics.size() < 2) {
            return Collections.emptyList();
        }
        CodeActionContext fixAllContext = new CodeActionContext();
        fixAllContext.setDiagnostics(suitableDiagnostics);
        fixAllContext.setOnly(Collections.singletonList("quickfix"));
        CodeActionParams fixAllParams = new CodeActionParams();
        fixAllParams.setTextDocument(params.getTextDocument());
        fixAllParams.setRange(params.getRange());
        fixAllParams.setContext(fixAllContext);
        Class<QuickFixProvider> quickFixProviderClass = quickFixClass.get();
        QuickFixProvider quickFixInstance = this.quickFixSupplier.getQuickFixInstance(quickFixProviderClass);
        return quickFixInstance.getQuickFixes(suitableDiagnostics, fixAllParams, documentContext);
    }
}

