/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses;

import com.github._1c_syntax.bsl.languageserver.codelenses.AbstractRunTestsCodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.codelenses.DefaultCodeLensData;
import com.github._1c_syntax.bsl.languageserver.codelenses.testrunner.TestRunnerAdapter;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.codelens.TestRunnerAdapterOptions;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RunTestCodeLensSupplier
extends AbstractRunTestsCodeLensSupplier<RunTestCodeLensData> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RunTestCodeLensSupplier.class);
    private static final String COMMAND_ID = "language-1c-bsl.languageServer.runTest";
    private final TestRunnerAdapter testRunnerAdapter;
    private final Resources resources;
    @Autowired
    @Lazy
    private RunTestCodeLensSupplier self;

    public RunTestCodeLensSupplier(LanguageServerConfiguration configuration, TestRunnerAdapter testRunnerAdapter, Resources resources) {
        super(configuration);
        this.testRunnerAdapter = testRunnerAdapter;
        this.resources = resources;
    }

    @Override
    public List<CodeLens> getCodeLenses(DocumentContext documentContext) {
        if (documentContext.getFileType() == FileType.BSL) {
            return Collections.emptyList();
        }
        List<String> testIds = this.testRunnerAdapter.getTestIds(documentContext);
        SymbolTree symbolTree = documentContext.getSymbolTree();
        return testIds.stream().map(symbolTree::getMethodSymbol).flatMap(Optional::stream).map(methodSymbol -> this.toCodeLens((MethodSymbol)methodSymbol, documentContext)).toList();
    }

    @Override
    public Class<RunTestCodeLensData> getCodeLensDataClass() {
        return RunTestCodeLensData.class;
    }

    @Override
    public CodeLens resolve(DocumentContext documentContext, CodeLens unresolved, RunTestCodeLensData data) {
        Path path = Paths.get(documentContext.getUri());
        String testId = data.getTestId();
        TestRunnerAdapterOptions options = this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions();
        String executable = options.getExecutableForCurrentOS();
        Object runText = executable + " " + options.getRunTestArguments();
        runText = String.format((String)runText, path, testId);
        Command command = new Command();
        command.setTitle(this.resources.getResourceString(this.getClass(), "runTest"));
        command.setCommand(COMMAND_ID);
        command.setArguments(List.of(Map.of("text", runText)));
        unresolved.setCommand(command);
        return unresolved;
    }

    private CodeLens toCodeLens(MethodSymbol method, DocumentContext documentContext) {
        String testId = method.getName();
        RunTestCodeLensData codeLensData = new RunTestCodeLensData(documentContext.getUri(), this.getId(), testId);
        CodeLens codeLens = new CodeLens(method.getSubNameRange());
        codeLens.setData((Object)codeLensData);
        return codeLens;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RunTestCodeLensSupplier getSelf() {
        return this.self;
    }

    public static final class RunTestCodeLensData
    extends DefaultCodeLensData {
        private final String testId;

        @ConstructorProperties(value={"uri", "id", "testId"})
        public RunTestCodeLensData(URI uri, String id, String testId) {
            super(uri, id);
            this.testId = testId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getTestId() {
            return this.testId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RunTestCodeLensData)) {
                return false;
            }
            RunTestCodeLensData other = (RunTestCodeLensData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$testId = this.getTestId();
            String other$testId = other.getTestId();
            return !(this$testId == null ? other$testId != null : !this$testId.equals(other$testId));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RunTestCodeLensData;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $testId = this.getTestId();
            result = result * 59 + ($testId == null ? 43 : $testId.hashCode());
            return result;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "RunTestCodeLensSupplier.RunTestCodeLensData(super=" + super.toString() + ", testId=" + this.getTestId() + ")";
        }
    }
}

