/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses.infrastructure;

import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensData;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class CodeLensesConfiguration {
    @Bean
    public Map<String, CodeLensSupplier<CodeLensData>> codeLensSuppliersById(Collection<CodeLensSupplier<? extends CodeLensData>> codeLensSuppliers) {
        return codeLensSuppliers.stream().map(codeLensSupplier -> codeLensSupplier).collect(Collectors.toMap(CodeLensSupplier::getId, Function.identity()));
    }

    @Bean
    @Scope(value="prototype")
    public List<CodeLensSupplier<CodeLensData>> enabledCodeLensSuppliers(LanguageServerConfiguration configuration, @Qualifier(value="codeLensSuppliersById") Map<String, CodeLensSupplier<CodeLensData>> codeLensSuppliersById) {
        Map<String, Either<Boolean, Map<String, Object>>> parameters = configuration.getCodeLensOptions().getParameters();
        return codeLensSuppliersById.values().stream().filter(supplier -> CodeLensesConfiguration.supplierIsEnabled(supplier.getId(), parameters)).collect(Collectors.toList());
    }

    private static boolean supplierIsEnabled(String supplierId, Map<String, Either<Boolean, Map<String, Object>>> parameters) {
        Either<Boolean, Map<String, Object>> supplierConfig = parameters.getOrDefault(supplierId, (Either<Boolean, Map<String, Object>>)Either.forLeft((Object)true));
        return supplierConfig.isRight() || (Boolean)supplierConfig.getLeft() != false;
    }
}

