/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses.testrunner;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.codelens.TestRunnerAdapterOptions;
import com.github._1c_syntax.bsl.languageserver.configuration.events.LanguageServerConfigurationChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@CacheConfig(cacheNames={"testIds"})
public class TestRunnerAdapter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TestRunnerAdapter.class);
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r?\n");
    private final LanguageServerConfiguration configuration;

    @EventListener
    @CacheEvict(allEntries=true)
    public void handleEvent(LanguageServerConfigurationChangedEvent event) {
    }

    @Cacheable
    public List<String> getTestIds(DocumentContext documentContext) {
        TestRunnerAdapterOptions options = this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions();
        if (options.isGetTestsByTestRunner()) {
            return this.computeTestIdsByTestRunner(documentContext);
        }
        return this.computeTestIdsByLanguageServer(documentContext);
    }

    private List<String> computeTestIdsByTestRunner(DocumentContext documentContext) {
        TestRunnerAdapterOptions options = this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions();
        String executable = SystemUtils.IS_OS_WINDOWS ? options.getExecutableWin() : options.getExecutable();
        String path = Paths.get(documentContext.getUri()).toString();
        String arguments = String.format(options.getGetTestsArguments(), path);
        CommandLine getTestsCommand = new CommandLine(executable).addArguments(arguments, false);
        long timeout = 10000L;
        ExecuteWatchdog watchdog = ExecuteWatchdog.builder().setTimeout(Duration.ofMillis(timeout)).get();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        try {
            executor.execute(getTestsCommand, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException e) {
            LOGGER.error("Can't execute testrunner getTests command", (Throwable)e);
            return Collections.emptyList();
        }
        try {
            resultHandler.waitFor();
        }
        catch (InterruptedException e) {
            LOGGER.error("Can't wait for testrunner getTests command", (Throwable)e);
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        Pattern getTestsRegex = Pattern.compile(options.getGetTestsResultPattern());
        Charset charset = SystemUtils.IS_OS_WINDOWS ? Charset.forName("cp866") : Charset.defaultCharset();
        String output = outputStream.toString(charset);
        return Arrays.stream(NEW_LINE_PATTERN.split(output)).map(getTestsRegex::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1)).toList();
    }

    private List<String> computeTestIdsByLanguageServer(DocumentContext documentContext) {
        Set<String> annotations = this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions().getAnnotations();
        return documentContext.getSymbolTree().getMethods().stream().filter(methodSymbol -> methodSymbol.getAnnotations().stream().map(Annotation::getName).anyMatch(annotations::contains)).map(MethodSymbol::getName).toList();
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TestRunnerAdapter(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

