/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.color;

import com.github._1c_syntax.bsl.languageserver.color.ColorInformationSupplier;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.languageserver.utils.bsl.Constructors;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.Range;
import org.springframework.stereotype.Component;

@Component
public class ConstructorColorInformationSupplier
implements ColorInformationSupplier {
    private static final Pattern COLOR_PATTERN = CaseInsensitivePattern.compile((String)"^(?:\u0426\u0432\u0435\u0442|Color)$");

    @Override
    public List<ColorInformation> getColorInformation(DocumentContext documentContext) {
        Collection<ParseTree> newExpressions = Trees.findAllRuleNodes((ParseTree)documentContext.getAst(), 90);
        return newExpressions.stream().map(BSLParser.NewExpressionContext.class::cast).filter(newExpression -> Constructors.typeName(newExpression).filter(name -> COLOR_PATTERN.matcher((CharSequence)name).matches()).isPresent()).map(ConstructorColorInformationSupplier::toColorInformation).collect(Collectors.toList());
    }

    private static ColorInformation toColorInformation(BSLParser.NewExpressionContext ctx) {
        byte bluePosition;
        byte greenPosition;
        byte redPosition;
        if (ctx.typeName() != null) {
            redPosition = 0;
            greenPosition = 1;
            bluePosition = 2;
        } else {
            redPosition = 1;
            greenPosition = 2;
            bluePosition = 3;
        }
        BSLParser.CallParamListContext callParams = Optional.ofNullable(ctx.doCall()).map(BSLParser.DoCallContext::callParamList).orElseGet(() -> new BSLParser.CallParamListContext(null, 0));
        double red = ConstructorColorInformationSupplier.getColorValue(callParams, redPosition);
        double green = ConstructorColorInformationSupplier.getColorValue(callParams, greenPosition);
        double blue = ConstructorColorInformationSupplier.getColorValue(callParams, bluePosition);
        Range range = Ranges.create((ParserRuleContext)ctx);
        Color color = new Color(red, green, blue, 1.0);
        return new ColorInformation(range, color);
    }

    private static Double getColorValue(BSLParser.CallParamListContext callParams, byte colorPosition) {
        return Optional.ofNullable(callParams.callParam((int)colorPosition)).map(BSLParser.CallParamContext::expression).filter(expression -> expression.getTokens().size() == 1).map(expression -> (Token)expression.getTokens().get(0)).map(Token::getText).map(ConstructorColorInformationSupplier::tryParseInteger).map(colorValue -> (double)colorValue.intValue() / 255.0).orElse(0.0);
    }

    private static Integer tryParseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

