/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Describable;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Exportable;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTreeVisitor;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.CompilerDirectiveKind;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

public final class MethodSymbol
implements SourceDefinedSymbol,
Exportable,
Describable {
    private final String name;
    private final SymbolKind symbolKind;
    private final DocumentContext owner;
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;
    private final int subNameLine;
    private final int subNameStartCharacter;
    private final int subNameEndCharacter;
    private Optional<SourceDefinedSymbol> parent;
    private final List<SourceDefinedSymbol> children;
    private final boolean function;
    private final boolean export;
    private final Optional<MethodDescription> description;
    private final boolean deprecated;
    private final List<ParameterDefinition> parameters;
    private final Optional<CompilerDirectiveKind> compilerDirectiveKind;
    private final List<Annotation> annotations;

    @Override
    public Range getRange() {
        return Ranges.create(this.startLine, this.startCharacter, this.endLine, this.endCharacter);
    }

    public Range getSubNameRange() {
        return Ranges.create(this.subNameLine, this.subNameStartCharacter, this.subNameLine, this.subNameEndCharacter);
    }

    public Optional<RegionSymbol> getRegion() {
        return this.getParent().filter(RegionSymbol.class::isInstance).map(RegionSymbol.class::cast);
    }

    @Override
    public void accept(SymbolTreeVisitor visitor) {
        visitor.visitMethod(this);
    }

    @Override
    public Range getSelectionRange() {
        return this.getSubNameRange();
    }

    public static MethodSymbolBuilder builder() {
        return new MethodSymbolBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static SymbolKind $default$symbolKind() {
        return SymbolKind.Method;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Optional<SourceDefinedSymbol> $default$parent() {
        return Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static List<SourceDefinedSymbol> $default$children() {
        return new ArrayList<SourceDefinedSymbol>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static List<ParameterDefinition> $default$parameters() {
        return Collections.emptyList();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Optional<CompilerDirectiveKind> $default$compilerDirectiveKind() {
        return Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static List<Annotation> $default$annotations() {
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"name", "symbolKind", "owner", "startLine", "startCharacter", "endLine", "endCharacter", "subNameLine", "subNameStartCharacter", "subNameEndCharacter", "parent", "children", "function", "export", "description", "deprecated", "parameters", "compilerDirectiveKind", "annotations"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    MethodSymbol(String name, SymbolKind symbolKind, DocumentContext owner, int startLine, int startCharacter, int endLine, int endCharacter, int subNameLine, int subNameStartCharacter, int subNameEndCharacter, Optional<SourceDefinedSymbol> parent, List<SourceDefinedSymbol> children, boolean function, boolean export, Optional<MethodDescription> description, boolean deprecated, List<ParameterDefinition> parameters, Optional<CompilerDirectiveKind> compilerDirectiveKind, List<Annotation> annotations) {
        this.name = name;
        this.symbolKind = symbolKind;
        this.owner = owner;
        this.startLine = startLine;
        this.startCharacter = startCharacter;
        this.endLine = endLine;
        this.endCharacter = endCharacter;
        this.subNameLine = subNameLine;
        this.subNameStartCharacter = subNameStartCharacter;
        this.subNameEndCharacter = subNameEndCharacter;
        this.parent = parent;
        this.children = children;
        this.function = function;
        this.export = export;
        this.description = description;
        this.deprecated = deprecated;
        this.parameters = parameters;
        this.compilerDirectiveKind = compilerDirectiveKind;
        this.annotations = annotations;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SymbolKind getSymbolKind() {
        return this.symbolKind;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocumentContext getOwner() {
        return this.owner;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SourceDefinedSymbol> getChildren() {
        return this.children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isFunction() {
        return this.function;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isExport() {
        return this.export;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<MethodDescription> getDescription() {
        return this.description;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<CompilerDirectiveKind> getCompilerDirectiveKind() {
        return this.compilerDirectiveKind;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodSymbol)) {
            return false;
        }
        MethodSymbol other = (MethodSymbol)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DocumentContext this$owner = this.getOwner();
        DocumentContext other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Range this$$getSubNameRange = this.getSubNameRange();
        Range other$$getSubNameRange = other.getSubNameRange();
        return !(this$$getSubNameRange == null ? other$$getSubNameRange != null : !this$$getSubNameRange.equals(other$$getSubNameRange));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DocumentContext $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Range $$getSubNameRange = this.getSubNameRange();
        result = result * 59 + ($$getSubNameRange == null ? 43 : $$getSubNameRange.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MethodSymbol(name=" + this.getName() + ", symbolKind=" + String.valueOf(this.getSymbolKind()) + ", owner=" + String.valueOf(this.getOwner()) + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ", subNameLine=" + this.subNameLine + ", subNameStartCharacter=" + this.subNameStartCharacter + ", subNameEndCharacter=" + this.subNameEndCharacter + ", function=" + this.isFunction() + ", export=" + this.isExport() + ", description=" + String.valueOf(this.getDescription()) + ", deprecated=" + this.isDeprecated() + ", parameters=" + String.valueOf(this.getParameters()) + ", compilerDirectiveKind=" + String.valueOf(this.getCompilerDirectiveKind()) + ", annotations=" + String.valueOf(this.getAnnotations()) + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<SourceDefinedSymbol> getParent() {
        return this.parent;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setParent(Optional<SourceDefinedSymbol> parent) {
        this.parent = parent;
    }

    public static class MethodSymbolBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean symbolKind$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SymbolKind symbolKind$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DocumentContext owner;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startCharacter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endCharacter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int subNameLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int subNameStartCharacter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int subNameEndCharacter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean parent$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Optional<SourceDefinedSymbol> parent$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean children$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<SourceDefinedSymbol> children$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean function;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean export;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Optional<MethodDescription> description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean deprecated;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean parameters$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<ParameterDefinition> parameters$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean compilerDirectiveKind$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Optional<CompilerDirectiveKind> compilerDirectiveKind$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean annotations$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Annotation> annotations$value;

        public MethodSymbolBuilder range(Range range) {
            Position start = range.getStart();
            Position end = range.getEnd();
            this.startLine = start.getLine();
            this.startCharacter = start.getCharacter();
            this.endLine = end.getLine();
            this.endCharacter = end.getCharacter();
            return this;
        }

        public MethodSymbolBuilder subNameRange(Range range) {
            Position start = range.getStart();
            Position end = range.getEnd();
            this.subNameLine = start.getLine();
            this.subNameStartCharacter = start.getCharacter();
            this.subNameEndCharacter = end.getCharacter();
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        MethodSymbolBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder symbolKind(SymbolKind symbolKind) {
            this.symbolKind$value = symbolKind;
            this.symbolKind$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder owner(DocumentContext owner) {
            this.owner = owner;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder startLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder startCharacter(int startCharacter) {
            this.startCharacter = startCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder endLine(int endLine) {
            this.endLine = endLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder endCharacter(int endCharacter) {
            this.endCharacter = endCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder subNameLine(int subNameLine) {
            this.subNameLine = subNameLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder subNameStartCharacter(int subNameStartCharacter) {
            this.subNameStartCharacter = subNameStartCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder subNameEndCharacter(int subNameEndCharacter) {
            this.subNameEndCharacter = subNameEndCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder parent(Optional<SourceDefinedSymbol> parent) {
            this.parent$value = parent;
            this.parent$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder children(List<SourceDefinedSymbol> children) {
            this.children$value = children;
            this.children$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder function(boolean function) {
            this.function = function;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder export(boolean export) {
            this.export = export;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder description(Optional<MethodDescription> description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder parameters(List<ParameterDefinition> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder compilerDirectiveKind(Optional<CompilerDirectiveKind> compilerDirectiveKind) {
            this.compilerDirectiveKind$value = compilerDirectiveKind;
            this.compilerDirectiveKind$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolBuilder annotations(List<Annotation> annotations) {
            this.annotations$value = annotations;
            this.annotations$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbol build() {
            SymbolKind symbolKind$value = this.symbolKind$value;
            if (!this.symbolKind$set) {
                symbolKind$value = MethodSymbol.$default$symbolKind();
            }
            Optional<SourceDefinedSymbol> parent$value = this.parent$value;
            if (!this.parent$set) {
                parent$value = MethodSymbol.$default$parent();
            }
            List<SourceDefinedSymbol> children$value = this.children$value;
            if (!this.children$set) {
                children$value = MethodSymbol.$default$children();
            }
            List<ParameterDefinition> parameters$value = this.parameters$value;
            if (!this.parameters$set) {
                parameters$value = MethodSymbol.$default$parameters();
            }
            Optional<CompilerDirectiveKind> compilerDirectiveKind$value = this.compilerDirectiveKind$value;
            if (!this.compilerDirectiveKind$set) {
                compilerDirectiveKind$value = MethodSymbol.$default$compilerDirectiveKind();
            }
            List<Annotation> annotations$value = this.annotations$value;
            if (!this.annotations$set) {
                annotations$value = MethodSymbol.$default$annotations();
            }
            return new MethodSymbol(this.name, symbolKind$value, this.owner, this.startLine, this.startCharacter, this.endLine, this.endCharacter, this.subNameLine, this.subNameStartCharacter, this.subNameEndCharacter, parent$value, children$value, this.function, this.export, this.description, this.deprecated, parameters$value, compilerDirectiveKind$value, annotations$value);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "MethodSymbol.MethodSymbolBuilder(name=" + this.name + ", symbolKind$value=" + String.valueOf(this.symbolKind$value) + ", owner=" + String.valueOf(this.owner) + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ", subNameLine=" + this.subNameLine + ", subNameStartCharacter=" + this.subNameStartCharacter + ", subNameEndCharacter=" + this.subNameEndCharacter + ", parent$value=" + String.valueOf(this.parent$value) + ", children$value=" + String.valueOf(this.children$value) + ", function=" + this.function + ", export=" + this.export + ", description=" + String.valueOf(this.description) + ", deprecated=" + this.deprecated + ", parameters$value=" + String.valueOf(this.parameters$value) + ", compilerDirectiveKind$value=" + String.valueOf(this.compilerDirectiveKind$value) + ", annotations$value=" + String.valueOf(this.annotations$value) + ")";
        }
    }
}

