/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.ModuleOwner;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Range;

public abstract class AbstractMetadataDiagnostic
extends AbstractDiagnostic {
    private static final List<ModuleType> OBJECT_MODULES = List.of(ModuleType.ObjectModule, ModuleType.ManagerModule, ModuleType.RecordSetModule, ModuleType.ValueManagerModule, ModuleType.BotModule, ModuleType.CommonModule, ModuleType.HTTPServiceModule, ModuleType.IntegrationServiceModule, ModuleType.WEBServiceModule);
    private final List<MDOType> filterMdoTypes;
    private Range diagnosticRange;

    protected AbstractMetadataDiagnostic(List<MDOType> types) {
        this.filterMdoTypes = new ArrayList<MDOType>(types);
    }

    protected AbstractMetadataDiagnostic() {
        this.filterMdoTypes = List.of(MDOType.ACCOUNTING_REGISTER, MDOType.ACCUMULATION_REGISTER, MDOType.BUSINESS_PROCESS, MDOType.CALCULATION_REGISTER, MDOType.CATALOG, MDOType.CHART_OF_ACCOUNTS, MDOType.CHART_OF_CALCULATION_TYPES, MDOType.CHART_OF_CHARACTERISTIC_TYPES, MDOType.CONSTANT, MDOType.DOCUMENT, MDOType.DOCUMENT_JOURNAL, MDOType.ENUM, MDOType.EXCHANGE_PLAN, MDOType.FILTER_CRITERION, MDOType.INFORMATION_REGISTER, MDOType.TASK);
    }

    @Override
    protected void check() {
        if (this.computeDiagnosticRange()) {
            if (this.documentContext.getModuleType() == ModuleType.SessionModule) {
                this.checkMetadataWithoutModules();
            } else {
                this.checkMetadataWithModules();
            }
        }
    }

    protected boolean computeDiagnosticRange() {
        this.diagnosticRange = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        return !Ranges.isEmpty(this.diagnosticRange);
    }

    protected void addDiagnostic(String message) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, message);
    }

    protected abstract void checkMetadata(MD var1);

    private void checkMetadataWithModules() {
        this.documentContext.getMdObject().filter(mdo -> this.filterMdoTypes.contains(mdo.getMdoType())).filter(ModuleOwner.class::isInstance).map(ModuleOwner.class::cast).filter(this::haveMatchingModule).ifPresent(this::checkMetadata);
    }

    private boolean haveMatchingModule(ModuleOwner mdo) {
        if (this.documentContext.getModuleType() == ModuleType.ManagerModule) {
            return true;
        }
        return mdo.getModules().stream().filter(mdoModule -> OBJECT_MODULES.contains(mdoModule.getModuleType())).count() == 1L;
    }

    private void checkMetadataWithoutModules() {
        this.documentContext.getServerContext().getConfiguration().getChildren().stream().filter(mdo -> this.filterMdoTypes.contains(mdo.getMdoType())).filter(mdo -> {
            ModuleOwner moduleOwner;
            return !(mdo instanceof ModuleOwner) || (moduleOwner = (ModuleOwner)mdo).getModules().stream().noneMatch(module -> OBJECT_MODULES.contains(module.getModuleType()));
        }).forEach(this::checkMetadata);
    }
}

