/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, activatedByDefault=false, tags={DiagnosticTag.DESIGN})
public class BadWordsDiagnostic
extends AbstractDiagnostic {
    private static final String BAD_WORDS_DEFAULT = "";
    private static final boolean FIND_IN_COMMENTS_DEFAULT = true;
    @DiagnosticParameter(type=String.class, defaultValue="")
    private Pattern badWords = CaseInsensitivePattern.compile((String)"");
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean findInComments = true;

    @Override
    public void configure(Map<String, Object> configuration) {
        this.badWords = CaseInsensitivePattern.compile((String)((String)configuration.getOrDefault("badWords", BAD_WORDS_DEFAULT)));
        this.findInComments = (Boolean)configuration.getOrDefault("findInComments", true);
    }

    @Override
    protected void check() {
        if (this.badWords.pattern().isBlank()) {
            return;
        }
        String[] moduleLines = this.documentContext.getContentList();
        if (this.findInComments) {
            this.checkAllLines(moduleLines);
            return;
        }
        this.checkLinesWithoutComments(moduleLines);
    }

    private void checkAllLines(String[] moduleLines) {
        for (int i = 0; i < moduleLines.length; ++i) {
            this.checkLine(moduleLines, i);
        }
    }

    private void checkLinesWithoutComments(String[] moduleLines) {
        int[] nclocData;
        for (int i : nclocData = this.documentContext.getMetrics().getNclocData()) {
            int moduleNumber = i - 1;
            this.checkLine(moduleLines, moduleNumber);
        }
    }

    private void checkLine(String[] lines, int lineNumber) {
        String moduleLine = lines[lineNumber];
        if (moduleLine.isEmpty()) {
            return;
        }
        Matcher matcher = this.badWords.matcher(moduleLine);
        while (matcher.find()) {
            this.diagnosticStorage.addDiagnostic(Ranges.create(lineNumber, matcher.start(), lineNumber, matcher.end()), this.info.getMessage(matcher.group()));
        }
    }
}

