/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, tags={DiagnosticTag.STANDARD})
public class BeginTransactionBeforeTryCatchDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern BEGIN_TRANSACTION_PATTERN = CaseInsensitivePattern.compile((String)"^\u041d\u0430\u0447\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e$|^BeginTransaction$");
    private BSLParserRuleContext nodeBeginTransaction = null;
    private BSLParser.StatementContext nodeEndFile = null;

    private static boolean isGlobalMethodBeginTransaction(BSLParser.StatementContext ctx) {
        if (ctx.getStart().getType() != 76) {
            return false;
        }
        return Optional.of(ctx).map(BSLParser.StatementContext::callStatement).map(BSLParser.CallStatementContext::globalMethodCall).map(BSLParser.GlobalMethodCallContext::methodName).map(methodNameContext -> BEGIN_TRANSACTION_PATTERN.matcher(methodNameContext.getText()).matches()).orElse(false);
    }

    public ParseTree visitStatement(BSLParser.StatementContext ctx) {
        if (ctx.getStart().getType() == 59) {
            this.nodeBeginTransaction = null;
            return (ParseTree)super.visitStatement(ctx);
        }
        if (this.nodeBeginTransaction != null) {
            this.diagnosticStorage.addDiagnostic(this.nodeBeginTransaction);
            this.nodeBeginTransaction = null;
        }
        if (BeginTransactionBeforeTryCatchDiagnostic.isGlobalMethodBeginTransaction(ctx)) {
            this.nodeBeginTransaction = ctx;
        }
        if (this.nodeEndFile != null && this.nodeBeginTransaction != null && this.nodeEndFile.equals(ctx)) {
            this.diagnosticStorage.addDiagnostic(this.nodeBeginTransaction);
            this.nodeBeginTransaction = null;
        }
        return (ParseTree)super.visitStatement(ctx);
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        Stream<ParseTree> statements = Trees.findAllRuleNodes((ParseTree)ctx, 80).stream();
        this.nodeEndFile = statements.reduce((a, b) -> b).orElse(null);
        return (ParseTree)super.visitFileCodeBlock(ctx);
    }
}

