/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.STANDARD})
public class CanonicalSpellingKeywordsDiagnostic
extends AbstractDiagnostic
implements QuickFixProvider {
    private static final Map<Integer, List<String>> canonicalKeywords = CanonicalSpellingKeywordsDiagnostic.getPreset();
    private static final Map<String, String> canonicalStrings = CanonicalSpellingKeywordsDiagnostic.getCanonical();

    private static Map<Integer, List<String>> getPreset() {
        return CanonicalSpellingKeywordsDiagnostic.getDefaultPreset();
    }

    private static Map<Integer, List<String>> getDefaultPreset() {
        HashMap<Integer, List<String>> result = new HashMap<Integer, List<String>>();
        result.put(49, List.of("\u0415\u0441\u043b\u0438", "If"));
        result.put(52, List.of("\u0422\u043e\u0433\u0434\u0430", "Then"));
        result.put(51, List.of("\u0418\u043d\u0430\u0447\u0435", "Else"));
        result.put(50, List.of("\u0418\u043d\u0430\u0447\u0435\u0415\u0441\u043b\u0438", "ElsIf"));
        result.put(47, List.of("\u041a\u043e\u043d\u0435\u0446\u0415\u0441\u043b\u0438", "EndIf"));
        result.put(55, List.of("\u0414\u043b\u044f", "For"));
        result.put(57, List.of("\u041a\u0430\u0436\u0434\u043e\u0433\u043e", "\u043a\u0430\u0436\u0434\u043e\u0433\u043e", "Each", "each"));
        result.put(58, List.of("\u0418\u0437", "In"));
        result.put(54, List.of("\u0426\u0438\u043a\u043b", "Do"));
        result.put(53, List.of("\u041f\u043e\u043a\u0430", "While"));
        result.put(71, List.of("\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c", "Break"));
        result.put(63, List.of("\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c", "Continue"));
        result.put(48, List.of("\u041a\u043e\u043d\u0435\u0446\u0426\u0438\u043a\u043b\u0430", "EndDo"));
        result.put(56, List.of("\u041f\u043e", "To"));
        result.put(41, List.of("\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430", "Procedure"));
        result.put(46, List.of("\u0417\u043d\u0430\u0447", "Val"));
        result.put(45, List.of("\u042d\u043a\u0441\u043f\u043e\u0440\u0442", "Export"));
        result.put(65, List.of("\u041f\u0435\u0440\u0435\u043c", "Var"));
        result.put(59, List.of("\u041f\u043e\u043f\u044b\u0442\u043a\u0430", "Try"));
        result.put(72, List.of("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c", "Execute"));
        result.put(62, List.of("\u0412\u043e\u0437\u0432\u0440\u0430\u0442", "Return"));
        result.put(30, List.of("\u0418\u0441\u0442\u0438\u043d\u0430", "True"));
        result.put(60, List.of("\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", "Except"));
        result.put(64, List.of("\u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", "Raise"));
        result.put(61, List.of("\u041a\u043e\u043d\u0435\u0446\u041f\u043e\u043f\u044b\u0442\u043a\u0438", "EndTry"));
        result.put(43, List.of("\u041a\u043e\u043d\u0435\u0446\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", "EndProcedure"));
        result.put(42, List.of("\u0424\u0443\u043d\u043a\u0446\u0438\u044f", "Function"));
        result.put(44, List.of("\u041a\u043e\u043d\u0435\u0446\u0424\u0443\u043d\u043a\u0446\u0438\u0438", "EndFunction"));
        result.put(31, List.of("\u041b\u043e\u0436\u044c", "False"));
        result.put(73, List.of("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a", "AddHandler"));
        result.put(74, List.of("\u0423\u0434\u0430\u043b\u0438\u0442\u044c\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a", "RemoveHandler"));
        result.put(70, List.of("\u041f\u0435\u0440\u0435\u0439\u0442\u0438", "Goto"));
        result.put(68, List.of("\u0418", "AND", "And"));
        result.put(67, List.of("\u0418\u043b\u0438", "\u0418\u041b\u0418", "Or", "OR"));
        result.put(66, List.of("\u041d\u0435", "\u041d\u0415", "Not", "NOT"));
        result.put(69, List.of("\u041d\u043e\u0432\u044b\u0439", "New"));
        result.put(32, List.of("\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e", "Undefined"));
        result.put(84, List.of("\u041e\u0431\u043b\u0430\u0441\u0442\u044c", "Region"));
        result.put(85, List.of("\u041a\u043e\u043d\u0435\u0446\u041e\u0431\u043b\u0430\u0441\u0442\u0438", "EndRegion"));
        result.put(89, List.of("\u0415\u0441\u043b\u0438", "If"));
        result.put(90, List.of("\u0422\u043e\u0433\u0434\u0430", "Then"));
        result.put(91, List.of("\u0418\u043d\u0430\u0447\u0435\u0415\u0441\u043b\u0438", "ElsIf"));
        result.put(93, List.of("\u0418\u043d\u0430\u0447\u0435", "Else"));
        result.put(92, List.of("\u041a\u043e\u043d\u0435\u0446\u0415\u0441\u043b\u0438", "EndIf"));
        result.put(87, List.of("\u0418\u043b\u0438", "\u0418\u041b\u0418", "Or", "OR"));
        result.put(88, List.of("\u0418", "And", "AND"));
        result.put(86, List.of("\u041d\u0435", "\u041d\u0415", "Not", "NOT"));
        result.put(105, List.of("\u0421\u0435\u0440\u0432\u0435\u0440", "Server"));
        result.put(103, List.of("\u041a\u043b\u0438\u0435\u043d\u0442", "Client"));
        result.put(94, List.of("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u041a\u043b\u0438\u0435\u043d\u0442", "MobileAppClient"));
        result.put(95, List.of("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u0421\u0435\u0440\u0432\u0435\u0440", "MobileAppServer"));
        result.put(96, List.of("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439\u041a\u043b\u0438\u0435\u043d\u0442", "MobileClient"));
        result.put(97, List.of("\u0422\u043e\u043b\u0441\u0442\u044b\u0439\u041a\u043b\u0438\u0435\u043d\u0442\u041e\u0431\u044b\u0447\u043d\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435", "ThickClientOrdinaryApplication"));
        result.put(98, List.of("\u0422\u043e\u043b\u0441\u0442\u044b\u0439\u041a\u043b\u0438\u0435\u043d\u0442\u0423\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435", "ThickClientManagedApplication"));
        result.put(99, List.of("\u0412\u043d\u0435\u0448\u043d\u0435\u0435\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", "ExternalConnection"));
        result.put(100, List.of("\u0422\u043e\u043d\u043a\u0438\u0439\u041a\u043b\u0438\u0435\u043d\u0442", "ThinClient"));
        result.put(101, List.of("\u0412\u0435\u0431\u041a\u043b\u0438\u0435\u043d\u0442", "WebClient"));
        result.put(102, List.of("\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435", "AtClient"));
        result.put(104, List.of("\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435", "AtServer"));
        result.put(116, List.of("\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435", "AtClient"));
        result.put(117, List.of("\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435", "AtServer"));
        result.put(113, List.of("\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435\u0411\u0435\u0437\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430", "AtServerNoContext"));
        result.put(114, List.of("\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435\u0411\u0435\u0437\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430", "AtClientAtServerNoContext"));
        result.put(115, List.of("\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435", "AtClientAtServer"));
        return result;
    }

    private static Map<String, String> getCanonical() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("\u0415\u0421\u041b\u0418", "\u0415\u0441\u043b\u0438");
        result.put("IF", "If");
        result.put("\u0422\u041e\u0413\u0414\u0410", "\u0422\u043e\u0433\u0434\u0430");
        result.put("THEN", "Then");
        result.put("\u0418\u041d\u0410\u0427\u0415", "\u0418\u043d\u0430\u0447\u0435");
        result.put("ELSE", "Else");
        result.put("\u0418\u041d\u0410\u0427\u0415\u0415\u0421\u041b\u0418", "\u0418\u043d\u0430\u0447\u0435\u0415\u0441\u043b\u0438");
        result.put("ELSIF", "ElsIf");
        result.put("\u041a\u041e\u041d\u0415\u0426\u0415\u0421\u041b\u0418", "\u041a\u043e\u043d\u0435\u0446\u0415\u0441\u043b\u0438");
        result.put("ENDIF", "EndIf");
        result.put("\u0414\u041b\u042f", "\u0414\u043b\u044f");
        result.put("FOR", "For");
        result.put("\u041a\u0410\u0416\u0414\u041e\u0413\u041e", "\u041a\u0430\u0436\u0434\u043e\u0433\u043e");
        result.put("EACH", "Each");
        result.put("\u0418\u0417", "\u0418\u0437");
        result.put("IN", "In");
        result.put("\u0426\u0418\u041a\u041b", "\u0426\u0438\u043a\u043b");
        result.put("DO", "Do");
        result.put("\u041f\u041e\u041a\u0410", "\u041f\u043e\u043a\u0430");
        result.put("WHILE", "While");
        result.put("\u041f\u0420\u0415\u0420\u0412\u0410\u0422\u042c", "\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c");
        result.put("BREAK", "Break");
        result.put("\u041f\u0420\u041e\u0414\u041e\u041b\u0416\u0418\u0422\u042c", "\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c");
        result.put("CONTINUE", "Continue");
        result.put("\u041a\u041e\u041d\u0415\u0426\u0426\u0418\u041a\u041b\u0410", "\u041a\u043e\u043d\u0435\u0446\u0426\u0438\u043a\u043b\u0430");
        result.put("ENDDO", "EndDo");
        result.put("\u041f\u041e", "\u041f\u043e");
        result.put("TO", "To");
        result.put("\u041f\u0420\u041e\u0426\u0415\u0414\u0423\u0420\u0410", "\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430");
        result.put("PROCEDURE", "Procedure");
        result.put("\u0417\u041d\u0410\u0427", "\u0417\u043d\u0430\u0447");
        result.put("VAL", "Val");
        result.put("\u042d\u041a\u0421\u041f\u041e\u0420\u0422", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442");
        result.put("EXPORT", "Export");
        result.put("\u041f\u0415\u0420\u0415\u041c", "\u041f\u0435\u0440\u0435\u043c");
        result.put("VAR", "Var");
        result.put("\u041f\u041e\u041f\u042b\u0422\u041a\u0410", "\u041f\u043e\u043f\u044b\u0442\u043a\u0430");
        result.put("TRY", "Try");
        result.put("\u0412\u042b\u041f\u041e\u041b\u041d\u0418\u0422\u042c", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c");
        result.put("EXECUTE", "Execute");
        result.put("\u0412\u041e\u0417\u0412\u0420\u0410\u0422", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442");
        result.put("RETURN", "Return");
        result.put("\u0418\u0421\u0422\u0418\u041d\u0410", "\u0418\u0441\u0442\u0438\u043d\u0430");
        result.put("TRUE", "True");
        result.put("\u0418\u0421\u041a\u041b\u042e\u0427\u0415\u041d\u0418\u0415", "\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
        result.put("EXCEPT", "Except");
        result.put("\u0412\u042b\u0417\u0412\u0410\u0422\u042c\u0418\u0421\u041a\u041b\u042e\u0427\u0415\u041d\u0418\u0415", "\u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
        result.put("RAISE", "Raise");
        result.put("\u041a\u041e\u041d\u0415\u0426\u041f\u041e\u041f\u042b\u0422\u041a\u0418", "\u041a\u043e\u043d\u0435\u0446\u041f\u043e\u043f\u044b\u0442\u043a\u0438");
        result.put("ENDTRY", "EndTry");
        result.put("\u041a\u041e\u041d\u0415\u0426\u041f\u0420\u041e\u0426\u0415\u0414\u0423\u0420\u042b", "\u041a\u043e\u043d\u0435\u0446\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b");
        result.put("ENDPROCEDURE", "EndProcedure");
        result.put("\u0424\u0423\u041d\u041a\u0426\u0418\u042f", "\u0424\u0443\u043d\u043a\u0446\u0438\u044f");
        result.put("FUNCTION", "Function");
        result.put("\u041a\u041e\u041d\u0415\u0426\u0424\u0423\u041d\u041a\u0426\u0418\u0418", "\u041a\u043e\u043d\u0435\u0446\u0424\u0443\u043d\u043a\u0446\u0438\u0438");
        result.put("ENDFUNCTION", "EndFunction");
        result.put("\u041b\u041e\u0416\u042c", "\u041b\u043e\u0436\u044c");
        result.put("FALSE", "False");
        result.put("\u0414\u041e\u0411\u0410\u0412\u0418\u0422\u042c\u041e\u0411\u0420\u0410\u0411\u041e\u0422\u0427\u0418\u041a", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a");
        result.put("ADDHANDLER", "AddHandler");
        result.put("\u0423\u0414\u0410\u041b\u0418\u0422\u042c\u041e\u0411\u0420\u0410\u0411\u041e\u0422\u0427\u0418\u041a", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a");
        result.put("REMOVEHANDLER", "RemoveHandler");
        result.put("\u041f\u0415\u0420\u0415\u0419\u0422\u0418", "\u041f\u0435\u0440\u0435\u0439\u0442\u0438");
        result.put("GOTO", "Goto");
        result.put("\u0418", "\u0418");
        result.put("AND", "AND");
        result.put("\u0418\u041b\u0418", "\u0418\u041b\u0418");
        result.put("OR", "OR");
        result.put("\u041d\u0415", "\u041d\u0415");
        result.put("NOT", "NOT");
        result.put("\u041d\u041e\u0412\u042b\u0419", "\u041d\u043e\u0432\u044b\u0439");
        result.put("NEW", "New");
        result.put("\u041d\u0415\u041e\u041f\u0420\u0415\u0414\u0415\u041b\u0415\u041d\u041e", "\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e");
        result.put("UNDEFINED", "Undefined");
        result.put("\u041e\u0411\u041b\u0410\u0421\u0422\u042c", "\u041e\u0431\u043b\u0430\u0441\u0442\u044c");
        result.put("REGION", "Region");
        result.put("\u041a\u041e\u041d\u0415\u0426\u041e\u0411\u041b\u0410\u0421\u0422\u0418", "\u041a\u043e\u043d\u0435\u0446\u041e\u0431\u043b\u0430\u0441\u0442\u0438");
        result.put("ENDREGION", "EndRegion");
        result.put("\u0421\u0415\u0420\u0412\u0415\u0420", "\u0421\u0435\u0440\u0432\u0435\u0440");
        result.put("SERVER", "Server");
        result.put("\u041a\u041b\u0418\u0415\u041d\u0422", "\u041a\u043b\u0438\u0435\u043d\u0442");
        result.put("CLIENT", "Client");
        result.put("\u041c\u041e\u0411\u0418\u041b\u042c\u041d\u041e\u0415\u041f\u0420\u0418\u041b\u041e\u0416\u0415\u041d\u0418\u0415\u041a\u041b\u0418\u0415\u041d\u0422", "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u041a\u043b\u0438\u0435\u043d\u0442");
        result.put("MOBILEAPPCLIENT", "MobileAppClient");
        result.put("\u041c\u041e\u0411\u0418\u041b\u042c\u041d\u041e\u0415\u041f\u0420\u0418\u041b\u041e\u0416\u0415\u041d\u0418\u0415\u0421\u0415\u0420\u0412\u0415\u0420", "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u0421\u0435\u0440\u0432\u0435\u0440");
        result.put("MOBILEAPPSERVER", "MobileAppServer");
        result.put("\u041c\u041e\u0411\u0418\u041b\u042c\u041d\u042b\u0419\u041a\u041b\u0418\u0415\u041d\u0422", "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439\u041a\u043b\u0438\u0435\u043d\u0442");
        result.put("MOBILECLIENT", "MobileClient");
        result.put("\u0422\u041e\u041b\u0421\u0422\u042b\u0419\u041a\u041b\u0418\u0415\u041d\u0422\u041e\u0411\u042b\u0427\u041d\u041e\u0415\u041f\u0420\u0418\u041b\u041e\u0416\u0415\u041d\u0418\u0415", "\u0422\u043e\u043b\u0441\u0442\u044b\u0439\u041a\u043b\u0438\u0435\u043d\u0442\u041e\u0431\u044b\u0447\u043d\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
        result.put("THICKCLIENTORDINARYAPPLICATION", "ThickClientOrdinaryApplication");
        result.put("\u0422\u041e\u041b\u0421\u0422\u042b\u0419\u041a\u041b\u0418\u0415\u041d\u0422\u0423\u041f\u0420\u0410\u0412\u041b\u042f\u0415\u041c\u041e\u0415\u041f\u0420\u0418\u041b\u041e\u0416\u0415\u041d\u0418\u0415", "\u0422\u043e\u043b\u0441\u0442\u044b\u0439\u041a\u043b\u0438\u0435\u043d\u0442\u0423\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
        result.put("THICKCLIENTMANAGEDAPPLICATION", "ThickClientManagedApplication");
        result.put("\u0412\u041d\u0415\u0428\u041d\u0415\u0415\u0421\u041e\u0415\u0414\u0418\u041d\u0415\u041d\u0418\u0415", "\u0412\u043d\u0435\u0448\u043d\u0435\u0435\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
        result.put("EXTERNALCONNECTION", "ExternalConnection");
        result.put("\u0422\u041e\u041d\u041a\u0418\u0419\u041a\u041b\u0418\u0415\u041d\u0422", "\u0422\u043e\u043d\u043a\u0438\u0439\u041a\u043b\u0438\u0435\u043d\u0442");
        result.put("THINCLIENT", "ThinClient");
        result.put("\u0412\u0415\u0411\u041a\u041b\u0418\u0415\u041d\u0422", "\u0412\u0435\u0431\u041a\u043b\u0438\u0435\u043d\u0442");
        result.put("WEBCLIENT", "WebClient");
        result.put("\u041d\u0410\u041a\u041b\u0418\u0415\u041d\u0422\u0415", "\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435");
        result.put("ATCLIENT", "AtClient");
        result.put("\u041d\u0410\u0421\u0415\u0420\u0412\u0415\u0420\u0415", "\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435");
        result.put("ATSERVER", "AtServer");
        result.put("\u041d\u0410\u0421\u0415\u0420\u0412\u0415\u0420\u0415\u0411\u0415\u0417\u041a\u041e\u041d\u0422\u0415\u041a\u0421\u0422\u0410", "\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435\u0411\u0435\u0437\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430");
        result.put("ATSERVERNOCONTEXT", "AtServerNoContext");
        result.put("\u041d\u0410\u041a\u041b\u0418\u0415\u041d\u0422\u0415\u041d\u0410\u0421\u0415\u0420\u0412\u0415\u0420\u0415\u0411\u0415\u0417\u041a\u041e\u041d\u0422\u0415\u041a\u0421\u0422\u0410", "\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435\u0411\u0435\u0437\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430");
        result.put("ATCLIENTATSERVERNOCONTEXT", "AtClientAtServerNoContext");
        result.put("\u041d\u0410\u041a\u041b\u0418\u0415\u041d\u0422\u0415\u041d\u0410\u0421\u0415\u0420\u0412\u0415\u0420\u0415", "\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435");
        result.put("ATCLIENTATSERVER", "AtClientAtServer");
        return result;
    }

    @Override
    protected void check() {
        this.documentContext.getTokensFromDefaultChannel().parallelStream().filter(t -> canonicalKeywords.get(t.getType()) != null && !canonicalKeywords.get(t.getType()).contains(t.getText())).forEach(token -> this.diagnosticStorage.addDiagnostic((Token)token, this.info.getMessage(token.getText())));
    }

    @Override
    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        diagnostics.forEach(diagnostic -> {
            Range range = diagnostic.getRange();
            String originalText = documentContext.getText(range);
            String canonicalText = canonicalStrings.get(originalText.toUpperCase(Locale.ENGLISH));
            if (canonicalText != null) {
                TextEdit textEdit = new TextEdit(range, canonicalText);
                textEdits.add(textEdit);
            }
        });
        return CodeActionProvider.createCodeActions(textEdits, this.info.getResourceString("quickFixMessage"), documentContext.getUri(), diagnostics);
    }
}

