/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.ERROR, DiagnosticTag.STANDARD, DiagnosticTag.UNPREDICTABLE})
public class InvalidCharacterInFileDiagnostic
extends AbstractDiagnostic
implements QuickFixProvider {
    public static final String SPACE_REGEX = "\\u00A0";
    private static final Pattern ILLEGAL_PATTERN = Pattern.compile("[\\u00AD\\u2012\\u2013\\u2014\\u2015\\u2212]|\\u00A0", 64);
    private static final Pattern ILLEGAL_SPACE_PATTERN = Pattern.compile("\\u00A0", 64);
    private String diagnosticMessageDash = "";
    private String diagnosticMessageSpace = "";

    @PostConstruct
    public void init() {
        this.diagnosticMessageDash = this.info.getResourceString("diagnosticMessageDash");
        this.diagnosticMessageSpace = this.info.getResourceString("diagnosticMessageSpace");
    }

    @Override
    public void check() {
        Set<Integer> stringTokenTypes = Set.of(Integer.valueOf(40), Integer.valueOf(37), Integer.valueOf(38), Integer.valueOf(39));
        this.documentContext.getTokens().stream().filter(token -> token.getChannel() == 1 || stringTokenTypes.contains(token.getType())).filter(token -> ILLEGAL_PATTERN.matcher(token.getText()).find()).forEach(token -> {
            String text = token.getText();
            String message = this.diagnosticMessageDash;
            if (ILLEGAL_SPACE_PATTERN.matcher(text).find()) {
                message = this.diagnosticMessageSpace;
            }
            this.diagnosticStorage.addDiagnostic((Token)token, message);
        });
    }

    @Override
    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        diagnostics.stream().filter(diagnostic -> diagnostic.getMessage().equals(this.diagnosticMessageSpace)).forEach(diagnostic -> {
            Range range = diagnostic.getRange();
            TextEdit textEdit = new TextEdit(range, ILLEGAL_SPACE_PATTERN.matcher(documentContext.getText(range)).replaceAll(" "));
            textEdits.add(textEdit);
        });
        diagnostics.stream().filter(diagnostic -> diagnostic.getMessage().equals(this.diagnosticMessageDash)).forEach(diagnostic -> {
            Range range = diagnostic.getRange();
            TextEdit textEdit = new TextEdit(range, ILLEGAL_PATTERN.matcher(documentContext.getText(range)).replaceAll("-"));
            textEdits.add(textEdit);
        });
        return CodeActionProvider.createCodeActions(textEdits, this.info.getResourceString("quickFixMessage"), documentContext.getUri(), diagnostics);
    }
}

