/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=30, tags={DiagnosticTag.BADPRACTICE})
public class MethodSizeDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int MAX_METHOD_SIZE = 200;
    @DiagnosticParameter(type=Integer.class, defaultValue="200")
    private int maxMethodSize = 200;

    public ParseTree visitProcedure(BSLParser.ProcedureContext ctx) {
        int methodSize = MethodSizeDiagnostic.methodSize(ctx.subCodeBlock());
        if (this.methodSizeExceedsLimit(methodSize)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx.procDeclaration().subName(), this.info.getMessage(ctx.procDeclaration().subName().getText(), methodSize, this.maxMethodSize));
        }
        return ctx;
    }

    public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
        int methodSize = MethodSizeDiagnostic.methodSize(ctx.subCodeBlock());
        if (this.methodSizeExceedsLimit(methodSize)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx.funcDeclaration().subName(), this.info.getMessage(ctx.funcDeclaration().subName().getText(), methodSize, this.maxMethodSize));
        }
        return ctx;
    }

    private boolean methodSizeExceedsLimit(int methodSize) {
        return methodSize > this.maxMethodSize;
    }

    private static int methodSize(BSLParser.SubCodeBlockContext ctx) {
        if (ctx.codeBlock().getChildCount() == 0) {
            return 0;
        }
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return stop.getLine() - start.getLine();
    }
}

