/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=15, tags={DiagnosticTag.STANDARD})
public class PairingBrokenTransactionDiagnostic
extends AbstractVisitorDiagnostic {
    private final Pattern beginTransaction = CaseInsensitivePattern.compile((String)"\u041d\u0430\u0447\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|BeginTransaction");
    private final Pattern beginEndTransaction = CaseInsensitivePattern.compile((String)"\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|CommitTransaction|\u041d\u0430\u0447\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|BeginTransaction");
    private final Pattern beginCancelTransaction = CaseInsensitivePattern.compile((String)"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|RollbackTransaction|\u041d\u0430\u0447\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|BeginTransaction");
    private final HashMap<String, String> pairMethodsBeginEnd = new HashMap();
    private final HashMap<String, String> pairMethodsBeginCancel = new HashMap();

    public PairingBrokenTransactionDiagnostic() {
        this.pairMethodsBeginEnd.put("\u041d\u0410\u0427\u0410\u0422\u042c\u0422\u0420\u0410\u041d\u0417\u0410\u041a\u0426\u0418\u042e", "\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
        this.pairMethodsBeginEnd.put("\u0417\u0410\u0424\u0418\u041a\u0421\u0418\u0420\u041e\u0412\u0410\u0422\u042c\u0422\u0420\u0410\u041d\u0417\u0410\u041a\u0426\u0418\u042e", "\u041d\u0430\u0447\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
        this.pairMethodsBeginEnd.put("BEGINTRANSACTION", "CommitTransaction");
        this.pairMethodsBeginEnd.put("COMMITTRANSACTION", "BeginTransaction");
        this.pairMethodsBeginCancel.put("\u041d\u0410\u0427\u0410\u0422\u042c\u0422\u0420\u0410\u041d\u0417\u0410\u041a\u0426\u0418\u042e", "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
        this.pairMethodsBeginCancel.put("\u041e\u0422\u041c\u0415\u041d\u0418\u0422\u042c\u0422\u0420\u0410\u041d\u0417\u0410\u041a\u0426\u0418\u042e", "\u041d\u0430\u0447\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
        this.pairMethodsBeginCancel.put("BEGINTRANSACTION", "RollbackTransaction");
        this.pairMethodsBeginCancel.put("ROLLBACKTRANSACTION", "BeginTransaction");
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        this.findAndAddDiagnostic((ParseTree)ctx, this.beginEndTransaction, this.pairMethodsBeginEnd);
        this.findAndAddDiagnostic((ParseTree)ctx, this.beginCancelTransaction, this.pairMethodsBeginCancel);
        return ctx;
    }

    private void findAndAddDiagnostic(ParseTree ctx, Pattern pattern, HashMap<String, String> pairMethods) {
        ArrayList allTranCalls = new ArrayList();
        Trees.findAllRuleNodes(ctx, 93).stream().filter(node -> pattern.matcher(((BSLParser.GlobalMethodCallContext)node).methodName().getText()).matches()).collect(Collectors.toCollection(() -> allTranCalls));
        ArrayDeque<ParseTree> beginCalls = new ArrayDeque<ParseTree>();
        for (ParseTree tranCall2 : allTranCalls) {
            if (this.beginTransaction.matcher(((BSLParser.GlobalMethodCallContext)tranCall2).methodName().getText()).matches()) {
                beginCalls.add(tranCall2);
                continue;
            }
            if (!beginCalls.isEmpty()) {
                beginCalls.pop();
                continue;
            }
            this.addDiagnosticWithMessage(tranCall2, pairMethods);
        }
        if (!beginCalls.isEmpty()) {
            beginCalls.forEach(tranCall -> this.addDiagnosticWithMessage((ParseTree)tranCall, pairMethods));
        }
    }

    private void addDiagnosticWithMessage(ParseTree tranCall, HashMap<String, String> pairMethods) {
        String methodName = ((BSLParser.GlobalMethodCallContext)tranCall).methodName().getText();
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)((BSLParser.GlobalMethodCallContext)tranCall), this.info.getMessage(pairMethods.get(methodName.toUpperCase(Locale.ENGLISH)), methodName));
    }
}

