/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSymbolTreeDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class ReservedParameterNamesDiagnostic
extends AbstractSymbolTreeDiagnostic {
    private static final String RESERVED_WORDS_DEFAULT = "";
    @DiagnosticParameter(type=String.class)
    private Pattern reservedWords = CaseInsensitivePattern.compile((String)"");

    @Override
    public void configure(Map<String, Object> configuration) {
        String incomingMask = (String)configuration.getOrDefault("reservedWords", RESERVED_WORDS_DEFAULT);
        this.reservedWords = CaseInsensitivePattern.compile((String)("^" + incomingMask.trim() + "$"));
    }

    @Override
    protected void check() {
        if (this.reservedWords.pattern().isBlank()) {
            return;
        }
        super.check();
    }

    @Override
    public void visitMethod(MethodSymbol methodSymbol) {
        List<ParameterDefinition> parameters = methodSymbol.getParameters();
        this.checkParameterName(parameters);
    }

    private void checkParameterName(List<ParameterDefinition> parameters) {
        parameters.forEach(parameter -> {
            Matcher matcher = this.reservedWords.matcher(parameter.getName());
            if (matcher.find()) {
                this.diagnosticStorage.addDiagnostic(parameter.getRange(), this.info.getMessage(parameter.getName()));
            }
        });
    }
}

