/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.diagnostics.typo.JLanguageToolPool;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE})
public class TypoDiagnostic
extends AbstractDiagnostic {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TypoDiagnostic.class);
    private static final AtomicReference<Object> languageToolPoolMap = new AtomicReference();
    private static final Map<String, Map<String, Boolean>> checkedWords = Map.of("en", new ConcurrentHashMap(), "ru", new ConcurrentHashMap());
    private static final Pattern SPACES_PATTERN = Pattern.compile("\\s+");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final String FORMAT_STRING_RU = "\u041b=|\u0427\u0426=|\u0427\u0414\u0426=|\u0427\u0421=|\u0427\u0420\u0414=|\u0427\u0420\u0413=|\u0427\u041d=|\u0427\u0412\u041d=|\u0427\u0413=|\u0427\u041e=|\u0414\u0424=|\u0414\u041b\u0424=|\u0414\u041f=|\u0411\u041b=|\u0411\u0418=";
    private static final String FORMAT_STRING_EN = "|L=|ND=|NFD=|NS=|NDS=|NGS=|NZ=|NLZ=|NG=|NN=|NF=|DF=|DLF=|DE=|BF=|BT=";
    private static final Pattern FORMAT_STRING_PATTERN = CaseInsensitivePattern.compile((String)"\u041b=|\u0427\u0426=|\u0427\u0414\u0426=|\u0427\u0421=|\u0427\u0420\u0414=|\u0427\u0420\u0413=|\u0427\u041d=|\u0427\u0412\u041d=|\u0427\u0413=|\u0427\u041e=|\u0414\u0424=|\u0414\u041b\u0424=|\u0414\u041f=|\u0411\u041b=|\u0411\u0418=|L=|ND=|NFD=|NS=|NDS=|NGS=|NZ=|NLZ=|NG=|NN=|NF=|DF=|DLF=|DE=|BF=|BT=");
    private static final Integer[] rulesToFind = new Integer[]{79, 98, 27, 36};
    private static final Set<Integer> tokenTypes = Set.of(Integer.valueOf(37), Integer.valueOf(76));
    private static final int DEFAULT_MIN_WORD_LENGTH = 3;
    private static final String DEFAULT_USER_WORDS_TO_IGNORE = "";
    @DiagnosticParameter(type=Integer.class, defaultValue="3")
    private int minWordLength = 3;
    @DiagnosticParameter(type=String.class)
    private String userWordsToIgnore = "";

    @Override
    public void configure(Map<String, Object> configuration) {
        super.configure(configuration);
        this.minWordLength = Math.max(this.minWordLength, 3);
    }

    private Set<String> getWordsToIgnore() {
        String delimiter = ",";
        Object exceptions = SPACES_PATTERN.matcher(this.info.getResourceString("diagnosticExceptions")).replaceAll(DEFAULT_USER_WORDS_TO_IGNORE);
        if (!this.userWordsToIgnore.isEmpty()) {
            exceptions = (String)exceptions + delimiter + SPACES_PATTERN.matcher(this.userWordsToIgnore).replaceAll(DEFAULT_USER_WORDS_TO_IGNORE);
        }
        return Arrays.stream(((String)exceptions).split(delimiter)).collect(Collectors.toSet());
    }

    private static JLanguageTool acquireLanguageTool(String lang) {
        return (JLanguageTool)TypoDiagnostic.getLanguageToolPoolMap().get(lang).checkOut();
    }

    private static void releaseLanguageTool(String lang, JLanguageTool languageTool) {
        TypoDiagnostic.getLanguageToolPoolMap().get(lang).checkIn(languageTool);
    }

    private Map<String, List<Token>> getTokensMap(DocumentContext documentContext) {
        Set<String> wordsToIgnore = this.getWordsToIgnore();
        HashMap<String, List<Token>> tokensMap = new HashMap<String, List<Token>>();
        Trees.findAllRuleNodes((ParseTree)documentContext.getAst(), rulesToFind).stream().map(BSLParserRuleContext.class::cast).flatMap(ruleContext -> ruleContext.getTokens().stream()).filter(token -> tokenTypes.contains(token.getType())).filter(token -> !FORMAT_STRING_PATTERN.matcher(token.getText()).find()).forEach(token -> {
            String curText = QUOTE_PATTERN.matcher(token.getText()).replaceAll(DEFAULT_USER_WORDS_TO_IGNORE).trim();
            String[] camelCaseSplitedWords = StringUtils.splitByCharacterTypeCamelCase((String)curText);
            Arrays.stream(camelCaseSplitedWords).filter(Predicate.not(String::isBlank)).filter(element -> element.length() >= this.minWordLength).filter(Predicate.not(wordsToIgnore::contains)).forEach(element -> tokensMap.computeIfAbsent((String)element, newElement -> new ArrayList()).add(token));
        });
        return tokensMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() {
        String lang = this.info.getResourceString("diagnosticLanguage");
        Map<String, Boolean> checkedWordsForLang = checkedWords.get(lang);
        Map<String, List<Token>> tokensMap = this.getTokensMap(this.documentContext);
        Set<String> uncheckedWords = tokensMap.keySet().stream().filter(word -> !checkedWordsForLang.containsKey(word)).collect(Collectors.toSet());
        if (uncheckedWords.isEmpty()) {
            this.fireDiagnosticOnCheckedWordsWithErrors(tokensMap);
            return;
        }
        String uncheckedWordsString = String.join((CharSequence)"\n\n", uncheckedWords);
        JLanguageTool languageTool = TypoDiagnostic.acquireLanguageTool(lang);
        List matches = Collections.emptyList();
        try {
            matches = languageTool.check(uncheckedWordsString, true, JLanguageTool.ParagraphHandling.ONLYNONPARA);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            TypoDiagnostic.releaseLanguageTool(lang, languageTool);
        }
        matches.stream().map(ruleMatch -> ruleMatch.getSentence().getTokens()[1].getToken()).forEach(word -> checkedWordsForLang.put((String)word, true));
        uncheckedWords.forEach(word -> checkedWordsForLang.putIfAbsent((String)word, false));
        this.fireDiagnosticOnCheckedWordsWithErrors(tokensMap);
    }

    private void fireDiagnosticOnCheckedWordsWithErrors(Map<String, List<Token>> tokensMap) {
        String lang = this.info.getResourceString("diagnosticLanguage");
        Map<String, Boolean> checkedWordsForLang = checkedWords.get(lang);
        tokensMap.entrySet().stream().filter(entry -> checkedWordsForLang.getOrDefault(entry.getKey(), false)).forEach(entry -> {
            String word = (String)entry.getKey();
            List tokens = (List)entry.getValue();
            tokens.forEach(token -> this.diagnosticStorage.addDiagnostic((Token)token, this.info.getMessage(word)));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Map<String, JLanguageToolPool> getLanguageToolPoolMap() {
        Object $value = languageToolPoolMap.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = languageToolPoolMap;
            synchronized (atomicReference) {
                $value = languageToolPoolMap.get();
                if ($value == null) {
                    Map<String, JLanguageToolPool> actualValue = Map.of("en", new JLanguageToolPool(Languages.getLanguageForShortCode((String)"en-US")), "ru", new JLanguageToolPool(Languages.getLanguageForShortCode((String)"ru")));
                    $value = actualValue == null ? languageToolPoolMap : actualValue;
                    languageToolPoolMap.set($value);
                }
            }
        }
        return (Map)($value == languageToolPoolMap ? null : $value);
    }
}

