/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MINOR, minutesToFix=10, tags={DiagnosticTag.DESIGN, DiagnosticTag.SUSPICIOUS})
public class UnreachableCodeDiagnostic
extends AbstractVisitorDiagnostic {
    private final List<Range> errorRanges = new ArrayList<Range>();
    private final List<Range> preprocessorRanges = new ArrayList<Range>();

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        this.errorRanges.clear();
        this.preprocessorRanges.clear();
        ArrayList<ParseTree> preprocessors = new ArrayList<ParseTree>(Trees.findAllRuleNodes((ParseTree)ctx, 19));
        if (preprocessors.isEmpty()) {
            return (ParseTree)super.visitFile(ctx);
        }
        ArrayDeque<ParseTree> previousNodes = new ArrayDeque<ParseTree>();
        for (ParseTree node : preprocessors) {
            if (((BSLParser.PreprocessorContext)node).preproc_if() != null) {
                previousNodes.push(node);
                continue;
            }
            if (((BSLParser.PreprocessorContext)node).preproc_else() != null || ((BSLParser.PreprocessorContext)node).preproc_elsif() != null) {
                this.savePreprocessorRange(previousNodes, (BSLParser.PreprocessorContext)node);
                previousNodes.push(node);
                continue;
            }
            this.savePreprocessorRange(previousNodes, (BSLParser.PreprocessorContext)node);
        }
        if (this.preprocessorRanges.size() > 1) {
            Collections.reverse(this.preprocessorRanges);
        }
        return (ParseTree)super.visitFile(ctx);
    }

    private void savePreprocessorRange(Deque<ParseTree> nodes, BSLParser.PreprocessorContext node) {
        if (!nodes.isEmpty()) {
            BSLParser.PreprocessorContext previous = (BSLParser.PreprocessorContext)nodes.pop();
            this.preprocessorRanges.add(Ranges.create(previous.getStop().getLine(), previous.getStop().getCharPositionInLine() + previous.getStop().getText().length() + 1, node.getStart().getLine(), node.getStart().getCharPositionInLine() - 1));
        }
    }

    public ParseTree visitContinueStatement(BSLParser.ContinueStatementContext ctx) {
        this.findAndAddDiagnostic((BSLParserRuleContext)ctx);
        return (ParseTree)super.visitContinueStatement(ctx);
    }

    public ParseTree visitReturnStatement(BSLParser.ReturnStatementContext ctx) {
        this.findAndAddDiagnostic((BSLParserRuleContext)ctx);
        return (ParseTree)super.visitReturnStatement(ctx);
    }

    public ParseTree visitGotoStatement(BSLParser.GotoStatementContext ctx) {
        this.findAndAddDiagnostic((BSLParserRuleContext)ctx);
        return (ParseTree)super.visitGotoStatement(ctx);
    }

    public ParseTree visitRaiseStatement(BSLParser.RaiseStatementContext ctx) {
        this.findAndAddDiagnostic((BSLParserRuleContext)ctx);
        return (ParseTree)super.visitRaiseStatement(ctx);
    }

    public ParseTree visitBreakStatement(BSLParser.BreakStatementContext ctx) {
        this.findAndAddDiagnostic((BSLParserRuleContext)ctx);
        return (ParseTree)super.visitBreakStatement(ctx);
    }

    private void findAndAddDiagnostic(BSLParserRuleContext ctx) {
        Position pos = new Position(ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine());
        for (Range range : this.errorRanges) {
            if (!Ranges.containsPosition(range, pos)) continue;
            return;
        }
        BSLParserRuleContext nodeParent = ctx.getParent();
        if (nodeParent == null) {
            return;
        }
        BSLParser.StatementContext ppNode = (BSLParser.StatementContext)nodeParent.getParent();
        if (ppNode == null) {
            return;
        }
        BSLParserRuleContext ppNodeParent = ppNode.getParent();
        if (ppNodeParent == null) {
            return;
        }
        List<BSLParserRuleContext> statements = Trees.getChildren((Tree)ppNodeParent, 80).stream().filter(node -> node.getStart().getType() != 9 && !Trees.nodeContains((ParseTree)node, 6, 7, 12)).collect(Collectors.toList());
        if (statements.size() > 1) {
            Collections.reverse(statements);
            BSLParserRuleContext endCurrentBlockNode = this.getEndCurrentBlockNode(statements, pos);
            if (!ppNode.equals(endCurrentBlockNode)) {
                Range newRange = Ranges.create(statements.get(statements.indexOf(ppNode) - 1).getStart(), endCurrentBlockNode.getStop());
                this.diagnosticStorage.addDiagnostic(newRange);
                this.errorRanges.add(newRange);
            }
        }
    }

    private BSLParserRuleContext getEndCurrentBlockNode(List<BSLParserRuleContext> statements, Position pos) {
        Range preprocRange = null;
        for (Range range : this.preprocessorRanges) {
            if (!Ranges.containsPosition(range, pos)) continue;
            preprocRange = range;
        }
        BSLParserRuleContext endCurrentBlockNode = statements.get(0);
        if (preprocRange != null) {
            for (BSLParserRuleContext statement : statements) {
                Position posStatement = new Position(statement.getStart().getLine(), statement.getStart().getCharPositionInLine());
                if (!Ranges.containsPosition(preprocRange, posStatement)) continue;
                endCurrentBlockNode = statement;
                break;
            }
        }
        return endCurrentBlockNode;
    }
}

