/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class UsageWriteLogEventDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern WRITELOGEVENT = CaseInsensitivePattern.compile((String)"\u0437\u0430\u043f\u0438\u0441\u044c\u0436\u0443\u0440\u043d\u0430\u043b\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438|writelogevent");
    private static final Pattern PATTERN_DETAIL_ERROR_DESCRIPTION = CaseInsensitivePattern.compile((String)"\u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0435\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043e\u0448\u0438\u0431\u043a\u0438|detailerrordescription");
    private static final Pattern PATTERN_BRIEF_ERROR_DESCRIPTION = CaseInsensitivePattern.compile((String)"\u043a\u0440\u0430\u0442\u043a\u043e\u0435\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043e\u0448\u0438\u0431\u043a\u0438|brieferrordescription");
    private static final Pattern PATTERN_ERROR_INFO = CaseInsensitivePattern.compile((String)"\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\u043e\u0431\u043e\u0448\u0438\u0431\u043a\u0435|errorinfo");
    private static final Pattern PATTERN_SIMPLE_ERROR_DESCRIPTION = CaseInsensitivePattern.compile((String)"\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u043e\u0448\u0438\u0431\u043a\u0438|errordescription");
    private static final Pattern PATTERN_EVENT_LOG_LEVEL = CaseInsensitivePattern.compile((String)"\u0443\u0440\u043e\u0432\u0435\u043d\u044c\u0436\u0443\u0440\u043d\u0430\u043b\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438|eventloglevel");
    private static final Pattern PATTERN_ERROR = CaseInsensitivePattern.compile((String)"\u043e\u0448\u0438\u0431\u043a\u0430|error");
    private static final Pattern ERROR_PROCESSING_ERROR = CaseInsensitivePattern.compile((String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430\u043e\u0448\u0438\u0431\u043e\u043a|errorprocessing");
    private static final int WRITE_LOG_EVENT_METHOD_PARAMS_COUNT = 5;
    public static final int COMMENTS_PARAM_INDEX = 4;
    public static final String NO_ERROR_LOG_LEVEL_INSIDE_EXCEPT_BLOCK = "noErrorLogLevelInsideExceptBlock";
    public static final String NO_DETAIL_ERROR_DESCRIPTION = "noDetailErrorDescription";
    public static final String WRONG_NUMBER_MESSAGE = "wrongNumberMessage";
    public static final String NO_SECOND_PARAMETER = "noSecondParameter";
    public static final String NO_COMMENT = "noComment";

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext context) {
        if (!UsageWriteLogEventDiagnostic.checkMethodName(context)) {
            return (ParseTree)super.visitGlobalMethodCall(context);
        }
        this.checkParams(context);
        return (ParseTree)super.defaultResult();
    }

    private void checkParams(BSLParser.GlobalMethodCallContext context) {
        List callParams = context.doCall().callParamList().callParam();
        if (!this.checkFirstParams(context, callParams)) {
            return;
        }
        if (UsageWriteLogEventDiagnostic.isInsideExceptBlock((BSLParserRuleContext)context)) {
            BSLParser.CallParamContext logLevelCtx = (BSLParser.CallParamContext)callParams.get(1);
            if (!UsageWriteLogEventDiagnostic.hasErrorLogLevel(logLevelCtx)) {
                this.fireIssue(context, NO_ERROR_LOG_LEVEL_INSIDE_EXCEPT_BLOCK);
                return;
            }
            BSLParser.CallParamContext commentCtx = (BSLParser.CallParamContext)callParams.get(4);
            if (!UsageWriteLogEventDiagnostic.isCommentCorrect(commentCtx)) {
                this.fireIssue(context, NO_DETAIL_ERROR_DESCRIPTION);
            }
        }
    }

    private boolean checkFirstParams(BSLParser.GlobalMethodCallContext context, List<? extends BSLParser.CallParamContext> callParams) {
        if (callParams.size() < 5) {
            this.fireIssue(context, WRONG_NUMBER_MESSAGE);
            return false;
        }
        BSLParser.CallParamContext secondParamCtx = callParams.get(1);
        if (secondParamCtx.getChildCount() == 0) {
            this.fireIssue(context, NO_SECOND_PARAMETER);
            return false;
        }
        BSLParser.CallParamContext commentCtx = callParams.get(4);
        if (commentCtx.getChildCount() == 0) {
            this.fireIssue(context, NO_COMMENT);
            return false;
        }
        return true;
    }

    private static boolean checkMethodName(BSLParser.GlobalMethodCallContext context) {
        return WRITELOGEVENT.matcher(context.methodName().getText()).matches();
    }

    private void fireIssue(BSLParser.GlobalMethodCallContext context, String messageKey) {
        String diagnosticMessage = this.info.getResourceString(messageKey);
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)context, diagnosticMessage);
    }

    private static boolean hasErrorLogLevel(BSLParser.CallParamContext callParamContext) {
        Optional<BSLParser.ComplexIdentifierContext> complexIdentifier = Optional.of(callParamContext).map(BSLParser.CallParamContext::expression).map(BSLParser.ExpressionContext::member).filter(memberContexts -> memberContexts.size() == 1).map(memberContexts -> (BSLParser.MemberContext)memberContexts.get(0)).map(BSLParser.MemberContext::complexIdentifier).filter(identifier -> identifier.IDENTIFIER() != null);
        if (complexIdentifier.isEmpty()) {
            return true;
        }
        boolean result = complexIdentifier.filter(identifier -> PATTERN_EVENT_LOG_LEVEL.matcher(identifier.IDENTIFIER().getText()).matches()).filter(identifier -> identifier.modifier().size() == 1).map(identifier -> identifier.modifier(0)).map(BSLParser.ModifierContext::accessProperty).filter(accessProperty -> PATTERN_ERROR.matcher(accessProperty.IDENTIFIER().getText()).matches()).isPresent();
        if (result) {
            return true;
        }
        return complexIdentifier.filter(identifier -> identifier.getChildCount() == 1).isPresent();
    }

    private static boolean isCommentCorrect(BSLParser.CallParamContext commentsCtx) {
        BSLParser.CodeBlockContext codeBlockContext = (BSLParser.CodeBlockContext)Trees.getRootParent((BSLParserRuleContext)commentsCtx, 72);
        if (codeBlockContext == null) {
            return false;
        }
        if (UsageWriteLogEventDiagnostic.hasRaiseStatement(codeBlockContext)) {
            return true;
        }
        return UsageWriteLogEventDiagnostic.isValidCommentExpression(codeBlockContext, commentsCtx.expression(), true);
    }

    private static boolean hasRaiseStatement(BSLParser.CodeBlockContext codeBlockContext) {
        return codeBlockContext.statement().stream().map(BSLParser.StatementContext::compoundStatement).filter(Objects::nonNull).map(BSLParser.CompoundStatementContext::raiseStatement).anyMatch(Objects::nonNull);
    }

    private static boolean isValidCommentExpression(BSLParser.CodeBlockContext codeBlock, @Nullable BSLParser.ExpressionContext expression, boolean checkPrevAssignment) {
        if (expression == null) {
            return true;
        }
        List<BSLParserRuleContext> methodCalls = Trees.findAllRuleNodes((ParseTree)expression, List.of(Integer.valueOf(93), Integer.valueOf(92))).stream().filter(BSLParserRuleContext.class::isInstance).map(BSLParserRuleContext.class::cast).collect(Collectors.toList());
        if (!methodCalls.isEmpty()) {
            if (UsageWriteLogEventDiagnostic.isErrorDescriptionCallCorrect(methodCalls)) {
                return true;
            }
            if (UsageWriteLogEventDiagnostic.hasSimpleErrorDescription(methodCalls) || UsageWriteLogEventDiagnostic.hasBriefErrorDescription(methodCalls)) {
                return false;
            }
        }
        return UsageWriteLogEventDiagnostic.isValidExpression(expression, codeBlock, checkPrevAssignment);
    }

    private static boolean isErrorDescriptionCallCorrect(Collection<BSLParserRuleContext> calls) {
        return calls.stream().filter(context -> UsageWriteLogEventDiagnostic.isAppropriateMethodName(context, PATTERN_DETAIL_ERROR_DESCRIPTION)).filter(context -> context instanceof BSLParser.GlobalMethodCallContext || context instanceof BSLParser.MethodCallContext && UsageWriteLogEventDiagnostic.isErrorProcessingCall((BSLParser.MethodCallContext)context)).anyMatch(UsageWriteLogEventDiagnostic::hasFirstDescendantGlobalCallWithPatternError);
    }

    private static boolean isAppropriateMethodName(BSLParserRuleContext context, Pattern patternDetailErrorDescription) {
        BSLParser.MethodNameContext methodNameContext = (BSLParser.MethodNameContext)context.getRuleContext(BSLParser.MethodNameContext.class, 0);
        return patternDetailErrorDescription.matcher(methodNameContext.getText()).matches();
    }

    private static boolean isErrorProcessingCall(BSLParser.MethodCallContext methodCallContext) {
        return Optional.of(methodCallContext).map(BSLParserRuleContext::getParent).filter(context -> context instanceof BSLParser.AccessCallContext).map(BSLParserRuleContext::getParent).filter(context -> context instanceof BSLParser.ModifierContext).map(BSLParserRuleContext::getParent).filter(context -> context instanceof BSLParser.ComplexIdentifierContext).map(BSLParser.ComplexIdentifierContext.class::cast).map(BSLParser.ComplexIdentifierContext::IDENTIFIER).filter(terminalNode -> ERROR_PROCESSING_ERROR.matcher(terminalNode.getText()).matches()).isPresent();
    }

    private static boolean hasFirstDescendantGlobalCallWithPatternError(BSLParserRuleContext globalCallCtx) {
        return Trees.findAllRuleNodes((ParseTree)globalCallCtx, 93).stream().map(BSLParser.GlobalMethodCallContext.class::cast).anyMatch(context -> UsageWriteLogEventDiagnostic.isAppropriateMethodName((BSLParserRuleContext)context, PATTERN_ERROR_INFO));
    }

    private static boolean hasSimpleErrorDescription(Collection<BSLParserRuleContext> globalCalls) {
        return globalCalls.stream().filter(context -> context instanceof BSLParser.GlobalMethodCallContext).anyMatch(context -> UsageWriteLogEventDiagnostic.isAppropriateMethodName(context, PATTERN_SIMPLE_ERROR_DESCRIPTION));
    }

    private static boolean hasBriefErrorDescription(Collection<BSLParserRuleContext> calls) {
        return calls.stream().filter(context -> UsageWriteLogEventDiagnostic.isAppropriateMethodName(context, PATTERN_BRIEF_ERROR_DESCRIPTION)).anyMatch(context -> context instanceof BSLParser.GlobalMethodCallContext || context instanceof BSLParser.MethodCallContext && UsageWriteLogEventDiagnostic.isErrorProcessingCall((BSLParser.MethodCallContext)context));
    }

    private static boolean isValidExpression(BSLParser.ExpressionContext context, BSLParser.CodeBlockContext codeBlock, boolean checkPrevAssignment) {
        return context.member().stream().allMatch(memberContext -> UsageWriteLogEventDiagnostic.isValidExpression(memberContext, codeBlock, checkPrevAssignment));
    }

    private static boolean isValidExpression(BSLParser.MemberContext context, BSLParser.CodeBlockContext codeBlock, boolean checkPrevAssignment) {
        BSLParser.ComplexIdentifierContext complexIdentifier;
        if (context.constValue() != null) {
            return false;
        }
        if (checkPrevAssignment && (complexIdentifier = context.complexIdentifier()) != null) {
            return UsageWriteLogEventDiagnostic.isValidVarAssignment(complexIdentifier, codeBlock);
        }
        return false;
    }

    private static boolean isValidVarAssignment(BSLParser.ComplexIdentifierContext identifierContext, BSLParser.CodeBlockContext codeBlock) {
        String varName = identifierContext.getText();
        return UsageWriteLogEventDiagnostic.getAssignment(varName, codeBlock).map(BSLParser.AssignmentContext::expression).map(expression -> UsageWriteLogEventDiagnostic.isValidCommentExpression(codeBlock, expression, false)).orElse(true);
    }

    private static Optional<BSLParser.AssignmentContext> getAssignment(String varName, BSLParser.CodeBlockContext codeBlock) {
        return Optional.of(codeBlock).map(BSLParser.CodeBlockContext::statement).filter(statementContexts -> !statementContexts.isEmpty()).map(statementContexts -> codeBlock.statement(0)).map(BSLParser.StatementContext::assignment).filter(assignmentContext -> assignmentContext.lValue().getText().equalsIgnoreCase(varName));
    }

    private static boolean isInsideExceptBlock(BSLParserRuleContext context) {
        return Trees.getRootParent(context, 63) != null;
    }
}

