/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics.infrastructure;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.context.annotation.Scope;

@Configuration
@Role(value=2)
public class DiagnosticInfosConfiguration {
    private final ApplicationContext applicationContext;
    private final LanguageServerConfiguration configuration;
    private final StringInterner stringInterner;

    @Bean(value={"diagnosticInfosByCode"})
    @Role(value=2)
    public Map<String, DiagnosticInfo> diagnosticInfosByCode() {
        String[] beanNames = this.applicationContext.getBeanNamesForAnnotation(DiagnosticMetadata.class);
        return Arrays.stream(beanNames).map(arg_0 -> ((ApplicationContext)this.applicationContext).getType(arg_0)).filter(Objects::nonNull).filter(BSLDiagnostic.class::isAssignableFrom).map(aClass -> aClass).map(this::createDiagnosticInfo).collect(Collectors.toMap(info -> info.getCode().getStringValue(), Function.identity()));
    }

    @Bean(value={"diagnosticInfosByDiagnosticClass"})
    @Role(value=2)
    public Map<Class<? extends BSLDiagnostic>, DiagnosticInfo> diagnosticInfosByDiagnosticClass() {
        return this.diagnosticInfosByCode().values().stream().collect(Collectors.toMap(DiagnosticInfo::getDiagnosticClass, Function.identity()));
    }

    @Bean(value={"diagnosticInfos"})
    @Role(value=2)
    public Collection<DiagnosticInfo> diagnosticInfos() {
        return this.diagnosticInfosByCode().values();
    }

    @Bean
    @Scope(value="prototype")
    public DiagnosticInfo diagnosticInfo(@Autowired(required=false) Class<? extends BSLDiagnostic> diagnosticClass) {
        return this.diagnosticInfosByDiagnosticClass().get(diagnosticClass);
    }

    private DiagnosticInfo createDiagnosticInfo(@Autowired(required=false) Class<? extends BSLDiagnostic> diagnosticClass) {
        return new DiagnosticInfo(diagnosticClass, this.configuration, this.stringInterner);
    }

    @ConstructorProperties(value={"applicationContext", "configuration", "stringInterner"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticInfosConfiguration(ApplicationContext applicationContext, LanguageServerConfiguration configuration, StringInterner stringInterner) {
        this.applicationContext = applicationContext;
        this.configuration = configuration;
        this.stringInterner = stringInterner;
    }
}

