/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics.infrastructure;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.DiagnosticsOptions;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.Mode;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.SkipSupport;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.SubsystemFilter;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.infrastructure.DiagnosticObjectProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.infrastructure.Disabled;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.MDChild;
import com.github._1c_syntax.bsl.support.CompatibilityMode;
import com.github._1c_syntax.bsl.support.SupportVariant;
import com.github._1c_syntax.bsl.types.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.beans.factory.annotation.Lookup;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.AnnotationUtils;

@Configuration
public abstract class DiagnosticsConfiguration {
    private final LanguageServerConfiguration configuration;
    private final DiagnosticObjectProvider diagnosticObjectProvider;

    @Bean
    @Scope(value="prototype")
    public List<BSLDiagnostic> diagnostics(DocumentContext documentContext) {
        Collection<DiagnosticInfo> diagnosticInfos = this.diagnosticInfos();
        DiagnosticsOptions diagnosticsOptions = this.configuration.getDiagnosticsOptions();
        if (DiagnosticsConfiguration.needToComputeDiagnostics(documentContext, diagnosticsOptions)) {
            FileType fileType = documentContext.getFileType();
            CompatibilityMode compatibilityMode = documentContext.getServerContext().getConfiguration().getCompatibilityMode();
            ModuleType moduleType = documentContext.getModuleType();
            return diagnosticInfos.stream().filter(diagnosticInfo -> this.isEnabled((DiagnosticInfo)diagnosticInfo, diagnosticsOptions)).filter(info -> DiagnosticsConfiguration.inScope(info, fileType)).filter(info -> DiagnosticsConfiguration.correctModuleType(info, moduleType, fileType)).filter(info -> DiagnosticsConfiguration.passedCompatibilityMode(info, compatibilityMode)).map(DiagnosticInfo::getDiagnosticClass).filter(diagnostic -> AnnotationUtils.findAnnotation((Class)diagnostic, Disabled.class) == null).map(this.diagnosticObjectProvider::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Lookup(value="diagnosticInfos")
    protected abstract Collection<DiagnosticInfo> diagnosticInfos();

    private static boolean needToComputeDiagnostics(DocumentContext documentContext, DiagnosticsOptions diagnosticsOptions) {
        return DiagnosticsConfiguration.checkSupport(documentContext, diagnosticsOptions) && DiagnosticsConfiguration.filterSubsystems(documentContext, diagnosticsOptions);
    }

    private static boolean filterSubsystems(DocumentContext documentContext, DiagnosticsOptions diagnosticsOptions) {
        Optional<MD> mdoObject = documentContext.getMdObject();
        SubsystemFilter subsystemsFilter = diagnosticsOptions.getSubsystemsFilter();
        if (mdoObject.isEmpty() || subsystemsFilter.getInclude().isEmpty() && subsystemsFilter.getExclude().isEmpty()) {
            return true;
        }
        List<String> subsystemsNames = DiagnosticsConfiguration.getSubsystemNames(documentContext.getServerContext().getConfiguration(), mdoObject.get());
        boolean include = subsystemsFilter.getInclude().isEmpty() || subsystemsNames.stream().anyMatch(mdoSystemName -> subsystemsFilter.getInclude().contains(mdoSystemName));
        boolean exclude = !subsystemsFilter.getExclude().isEmpty() && subsystemsNames.stream().anyMatch(mdoSystemName -> subsystemsFilter.getExclude().contains(mdoSystemName));
        return include && !exclude;
    }

    private static boolean checkSupport(DocumentContext documentContext, DiagnosticsOptions diagnosticsOptions) {
        Mode configuredMode = diagnosticsOptions.getMode();
        if (configuredMode == Mode.OFF) {
            return false;
        }
        SkipSupport configuredSkipSupport = diagnosticsOptions.getSkipSupport();
        if (configuredSkipSupport == SkipSupport.NEVER) {
            return true;
        }
        SupportVariant moduleSupportVariant = documentContext.getSupportVariant();
        if (moduleSupportVariant == SupportVariant.NONE) {
            return true;
        }
        if (configuredSkipSupport == SkipSupport.WITH_SUPPORT_LOCKED) {
            return moduleSupportVariant != SupportVariant.NOT_EDITABLE;
        }
        return configuredSkipSupport != SkipSupport.WITH_SUPPORT;
    }

    private boolean isEnabled(DiagnosticInfo diagnosticInfo, DiagnosticsOptions diagnosticsOptions) {
        Mode mode = diagnosticsOptions.getMode();
        if (mode == Mode.OFF) {
            return false;
        }
        Either<Boolean, Map<String, Object>> diagnosticParameters = this.configuration.getDiagnosticsOptions().getParameters().get(diagnosticInfo.getCode().getStringValue());
        boolean activatedByDefault = diagnosticParameters == null && diagnosticInfo.isActivatedByDefault();
        boolean hasCustomConfiguration = diagnosticParameters != null && diagnosticParameters.isRight();
        boolean enabledDirectly = diagnosticParameters != null && diagnosticParameters.isLeft() && (Boolean)diagnosticParameters.getLeft() != false;
        boolean disabledDirectly = diagnosticParameters != null && diagnosticParameters.isLeft() && (Boolean)diagnosticParameters.getLeft() == false;
        boolean hasDefinedSetting = enabledDirectly || hasCustomConfiguration;
        boolean passedAllMode = mode == Mode.ALL;
        boolean passedOnlyMode = mode == Mode.ONLY && hasDefinedSetting;
        boolean passedExcept = mode == Mode.EXCEPT && !hasDefinedSetting && !disabledDirectly;
        boolean passedOn = mode == Mode.ON && (activatedByDefault || hasDefinedSetting);
        return passedOn || passedAllMode || passedOnlyMode || passedExcept;
    }

    private static boolean inScope(DiagnosticInfo diagnosticInfo, FileType fileType) {
        DiagnosticScope scope = diagnosticInfo.getScope();
        DiagnosticScope fileScope = fileType == FileType.OS ? DiagnosticScope.OS : DiagnosticScope.BSL;
        return scope == DiagnosticScope.ALL || scope == fileScope;
    }

    private static boolean correctModuleType(DiagnosticInfo diagnosticInfo, ModuleType moduletype, FileType fileType) {
        if (fileType == FileType.OS) {
            return true;
        }
        ModuleType[] diagnosticModules = diagnosticInfo.getModules();
        if (diagnosticModules.length == 0) {
            return true;
        }
        boolean contain = false;
        for (ModuleType module : diagnosticModules) {
            if (module != moduletype) continue;
            contain = true;
            break;
        }
        return contain;
    }

    private static boolean passedCompatibilityMode(DiagnosticInfo diagnosticInfo, CompatibilityMode contextCompatibilityMode) {
        DiagnosticCompatibilityMode compatibilityMode = diagnosticInfo.getCompatibilityMode();
        if (compatibilityMode == DiagnosticCompatibilityMode.UNDEFINED) {
            return true;
        }
        return CompatibilityMode.compareTo((CompatibilityMode)compatibilityMode.getCompatibilityMode(), (CompatibilityMode)contextCompatibilityMode) >= 0;
    }

    private static List<String> getSubsystemNames(CF configuration, MD mdObject) {
        MDChild child;
        Optional parent;
        List<String> subsystemsNames = configuration.includedSubsystems(mdObject, true).stream().map(MD::getName).collect(Collectors.toList());
        if (subsystemsNames.isEmpty() && mdObject instanceof MDChild && (parent = configuration.findChild((child = (MDChild)mdObject).getOwner())).isPresent()) {
            subsystemsNames = DiagnosticsConfiguration.getSubsystemNames(configuration, (MD)parent.get());
        }
        return subsystemsNames;
    }

    @ConstructorProperties(value={"configuration", "diagnosticObjectProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticsConfiguration(LanguageServerConfiguration configuration, DiagnosticObjectProvider diagnosticObjectProvider) {
        this.configuration = configuration;
        this.diagnosticObjectProvider = diagnosticObjectProvider;
    }
}

