/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics.metadata;

import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class DiagnosticParameterInfo {
    private final Class<?> type;
    private final String name;
    private final String description;
    private final Object defaultValue;

    private DiagnosticParameterInfo(Field field, String description) {
        DiagnosticParameter diagnosticParameter = field.getAnnotation(DiagnosticParameter.class);
        this.type = diagnosticParameter.type();
        this.name = field.getName();
        this.description = description;
        this.defaultValue = this.castDiagnosticParameterValue(diagnosticParameter.defaultValue());
    }

    private Object castDiagnosticParameterValue(String valueToCast) {
        Object value;
        if (this.type == Integer.class) {
            value = Integer.parseInt(valueToCast);
        } else if (this.type == Boolean.class) {
            value = Boolean.parseBoolean(valueToCast);
        } else if (this.type == Float.class) {
            value = Float.valueOf(Float.parseFloat(valueToCast));
        } else if (this.type == String.class) {
            value = valueToCast;
        } else {
            throw new IllegalArgumentException("Unsupported diagnostic parameter type " + String.valueOf(this.type));
        }
        return value;
    }

    static List<DiagnosticParameterInfo> createDiagnosticParameters(DiagnosticInfo diagnosticInfo) {
        List<DiagnosticParameterInfo> parameterInfos = DiagnosticParameterInfo.getParameterByClass(diagnosticInfo.getDiagnosticClass(), diagnosticInfo);
        Class<? extends BSLDiagnostic> superClass = diagnosticInfo.getDiagnosticClass().getSuperclass();
        if (superClass != null) {
            parameterInfos.addAll(DiagnosticParameterInfo.getParameterByClass(superClass, diagnosticInfo));
        }
        return parameterInfos;
    }

    private static List<DiagnosticParameterInfo> getParameterByClass(Class<?> clazz, DiagnosticInfo diagnosticInfo) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(DiagnosticParameter.class)).map(field -> new DiagnosticParameterInfo((Field)field, diagnosticInfo.getResourceString(field.getName()))).collect(Collectors.toList());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

