/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.folding;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.folding.FoldingRangeSupplier;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.FoldingRange;
import org.springframework.stereotype.Component;

@Component
public class PreprocIfFoldingRangeSupplier
implements FoldingRangeSupplier {
    @Override
    public List<FoldingRange> getFoldingRanges(DocumentContext documentContext) {
        PreprocIfVisitor preprocIfVisitor = new PreprocIfVisitor();
        preprocIfVisitor.visitFile(documentContext.getAst());
        return preprocIfVisitor.getRegionRanges();
    }

    private static class PreprocIfVisitor
    extends BSLParserBaseVisitor<ParseTree> {
        private final List<FoldingRange> regionRanges = new ArrayList<FoldingRange>();
        private final Deque<BSLParser.Preproc_ifContext> preprocIfRegionStack = new ArrayDeque<BSLParser.Preproc_ifContext>();

        private PreprocIfVisitor() {
        }

        public ParseTree visitPreproc_if(BSLParser.Preproc_ifContext ctx) {
            this.preprocIfRegionStack.push(ctx);
            return (ParseTree)super.visitPreproc_if(ctx);
        }

        public ParseTree visitPreproc_endif(BSLParser.Preproc_endifContext ctx) {
            if (this.preprocIfRegionStack.isEmpty()) {
                return (ParseTree)super.visitPreproc_endif(ctx);
            }
            BSLParser.Preproc_ifContext regionStart = this.preprocIfRegionStack.pop();
            int start = regionStart.getStart().getLine();
            int stop = ctx.getStop().getLine();
            FoldingRange foldingRange = new FoldingRange(start - 1, stop - 1);
            foldingRange.setKind("region");
            this.regionRanges.add(foldingRange);
            return (ParseTree)super.visitPreproc_endif(ctx);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<FoldingRange> getRegionRanges() {
            return this.regionRanges;
        }
    }
}

