/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.folding;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.folding.FoldingRangeSupplier;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.FoldingRange;
import org.springframework.stereotype.Component;

@Component
public class RegionFoldingRangeSupplier
implements FoldingRangeSupplier {
    @Override
    public List<FoldingRange> getFoldingRanges(DocumentContext documentContext) {
        return documentContext.getSymbolTree().getRegionsFlat().stream().map(RegionFoldingRangeSupplier::toFoldingRange).collect(Collectors.toList());
    }

    private static FoldingRange toFoldingRange(RegionSymbol regionSymbol) {
        FoldingRange foldingRange = new FoldingRange(regionSymbol.getStartRange().getStart().getLine(), regionSymbol.getEndRange().getEnd().getLine());
        foldingRange.setKind("region");
        return foldingRange;
    }
}

