/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.hover;

import com.github._1c_syntax.bsl.languageserver.context.symbol.AnnotationParamSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.hover.DescriptionFormatter;
import com.github._1c_syntax.bsl.languageserver.hover.MarkupContentBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.StringJoiner;
import lombok.Generated;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public class AnnotationParamSymbolMarkupContentBuilder
implements MarkupContentBuilder<AnnotationParamSymbol> {
    private final DescriptionFormatter descriptionFormatter;

    @Override
    public MarkupContent getContent(AnnotationParamSymbol symbol) {
        Optional<SourceDefinedSymbol> maybeMethodSymbol = symbol.getParent();
        if (maybeMethodSymbol.filter(MethodSymbol.class::isInstance).isEmpty()) {
            return new MarkupContent("markdown", "");
        }
        StringJoiner markupBuilder = new StringJoiner("\n");
        MethodSymbol methodSymbol = (MethodSymbol)maybeMethodSymbol.get();
        Optional<ParameterDefinition> maybeParameterDefinition = methodSymbol.getParameters().stream().filter(parameter -> parameter.getName().equalsIgnoreCase(symbol.getName())).findFirst();
        if (maybeParameterDefinition.isEmpty()) {
            return new MarkupContent("markdown", "");
        }
        ParameterDefinition parameterDefinition = maybeParameterDefinition.get();
        String parameter2 = this.descriptionFormatter.parameterToString(parameterDefinition);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, parameter2);
        String content = markupBuilder.toString();
        return new MarkupContent("markdown", content);
    }

    @Override
    public SymbolKind getSymbolKind() {
        return SymbolKind.TypeParameter;
    }

    @ConstructorProperties(value={"descriptionFormatter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AnnotationParamSymbolMarkupContentBuilder(DescriptionFormatter descriptionFormatter) {
        this.descriptionFormatter = descriptionFormatter;
    }
}

