/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.hover;

import com.github._1c_syntax.bsl.languageserver.context.symbol.AnnotationSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.hover.DescriptionFormatter;
import com.github._1c_syntax.bsl.languageserver.hover.MarkupContentBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.StringJoiner;
import lombok.Generated;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public class AnnotationSymbolMarkupContentBuilder
implements MarkupContentBuilder<AnnotationSymbol> {
    private final DescriptionFormatter descriptionFormatter;

    @Override
    public MarkupContent getContent(AnnotationSymbol symbol) {
        Optional<SourceDefinedSymbol> maybeMethodSymbol = symbol.getParent();
        if (maybeMethodSymbol.filter(MethodSymbol.class::isInstance).isEmpty()) {
            return new MarkupContent("markdown", "");
        }
        StringJoiner markupBuilder = new StringJoiner("\n");
        MethodSymbol methodSymbol = (MethodSymbol)maybeMethodSymbol.get();
        String signature = this.descriptionFormatter.getSignature(symbol, methodSymbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, signature);
        String methodLocation = this.descriptionFormatter.getLocation(methodSymbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, methodLocation);
        String purposeSection = this.descriptionFormatter.getPurposeSection(methodSymbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, purposeSection);
        String parametersSection = this.descriptionFormatter.getParametersSection(methodSymbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, parametersSection);
        String examplesSection = this.descriptionFormatter.getExamplesSection(methodSymbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, examplesSection);
        String callOptionsSection = this.descriptionFormatter.getCallOptionsSection(methodSymbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, callOptionsSection);
        String content = markupBuilder.toString();
        return new MarkupContent("markdown", content);
    }

    @Override
    public SymbolKind getSymbolKind() {
        return SymbolKind.Interface;
    }

    @ConstructorProperties(value={"descriptionFormatter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AnnotationSymbolMarkupContentBuilder(DescriptionFormatter descriptionFormatter) {
        this.descriptionFormatter = descriptionFormatter;
    }
}

