/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.hover;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.AnnotationSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.TypeDescription;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public class DescriptionFormatter {
    private static final String PROCEDURE_KEY = "procedure";
    private static final String FUNCTION_KEY = "function";
    private static final String ANNOTATION_KEY = "annotation";
    private static final String EXPORT_KEY = "export";
    private static final String VAL_KEY = "val";
    private static final String VARIABLE_KEY = "var";
    private static final String PARAMETERS_KEY = "parameters";
    private static final String RETURNED_VALUE_KEY = "returnedValue";
    private static final String EXAMPLES_KEY = "examples";
    private static final String CALL_OPTIONS_KEY = "callOptions";
    private static final String PARAMETER_TEMPLATE = "* **%s**: %s";
    private final Resources resources;

    public void addSectionIfNotEmpty(StringJoiner markupBuilder, String newContent) {
        if (!newContent.isEmpty()) {
            markupBuilder.add(newContent);
            markupBuilder.add("");
            markupBuilder.add("---");
        }
    }

    public String getPurposeSection(MethodSymbol methodSymbol) {
        return methodSymbol.getDescription().map(MethodDescription::getPurposeDescription).orElse("");
    }

    public String getParametersSection(MethodSymbol methodSymbol) {
        StringJoiner result = new StringJoiner("  \n");
        methodSymbol.getParameters().forEach(parameterDefinition -> result.add(this.parameterToString((ParameterDefinition)parameterDefinition)));
        String parameters = result.toString();
        if (!parameters.isBlank()) {
            StringJoiner parametersSection = new StringJoiner("\n");
            String header = "**" + this.getResourceString(PARAMETERS_KEY) + ":**";
            parametersSection.add(header);
            parametersSection.add("");
            parametersSection.add(parameters);
            return parametersSection.toString();
        }
        return "";
    }

    public String getReturnedValueSection(MethodSymbol methodSymbol) {
        StringJoiner result = new StringJoiner("  \n");
        methodSymbol.getDescription().ifPresent(methodDescription -> {
            Map<String, String> typesMap = this.typesToMap(methodDescription.getReturnedValue(), 0);
            result.add(DescriptionFormatter.typesMapToString(typesMap, 1));
        });
        Object returnedValue = result.toString();
        if (!((String)returnedValue).isEmpty()) {
            returnedValue = "**" + this.getResourceString(RETURNED_VALUE_KEY) + ":**\n\n" + (String)returnedValue;
        }
        return returnedValue;
    }

    public String getExamplesSection(MethodSymbol methodSymbol) {
        List examples = methodSymbol.getDescription().map(MethodDescription::getExamples).orElseGet(Collections::emptyList);
        return this.getSectionWithCodeFences(examples, EXAMPLES_KEY);
    }

    public String getCallOptionsSection(MethodSymbol methodSymbol) {
        List callOptions = methodSymbol.getDescription().map(MethodDescription::getCallOptions).orElseGet(Collections::emptyList);
        return this.getSectionWithCodeFences(callOptions, CALL_OPTIONS_KEY);
    }

    public String getSectionWithCodeFences(Collection<String> codeBlocks, String resourceKey) {
        Object codeFences = codeBlocks.stream().map(codeBlock -> "```bsl\n" + codeBlock + "\n```").collect(Collectors.joining("\n"));
        if (!((String)codeFences).isEmpty()) {
            codeFences = "**" + this.getResourceString(resourceKey) + ":**\n\n" + (String)codeFences;
        }
        return codeFences;
    }

    public String getLocation(MethodSymbol symbol) {
        DocumentContext documentContext = symbol.getOwner();
        Position startPosition = symbol.getSelectionRange().getStart();
        String mdoRef = MdoRefBuilder.getMdoRef(documentContext);
        return String.format("[%s](%s#%d)", mdoRef, documentContext.getUri(), startPosition.getLine() + 1);
    }

    public String getLocation(VariableSymbol symbol) {
        DocumentContext documentContext = symbol.getOwner();
        Position startPosition = symbol.getSelectionRange().getStart();
        Object mdoRef = MdoRefBuilder.getMdoRef(documentContext);
        String parentPostfix = symbol.getRootParent(SymbolKind.Method).map(sourceDefinedSymbol -> "." + sourceDefinedSymbol.getName()).orElse("");
        mdoRef = (String)mdoRef + parentPostfix;
        return String.format("[%s](%s#%d)", mdoRef, documentContext.getUri(), startPosition.getLine() + 1);
    }

    public String getSignature(MethodSymbol methodSymbol) {
        String signatureTemplate = "```bsl\n%s %s(%s)%s%s\n```";
        String methodKind = methodSymbol.isFunction() ? this.getResourceString(FUNCTION_KEY) : this.getResourceString(PROCEDURE_KEY);
        String methodName = methodSymbol.getName();
        String parameters = this.getParametersSignatureDescription(methodSymbol);
        String returnedValueType = DescriptionFormatter.getReturnedValueTypeDescriptionPart(methodSymbol);
        String export = methodSymbol.isExport() ? " " + this.getResourceString(EXPORT_KEY) : "";
        return String.format(signatureTemplate, methodKind, methodName, parameters, export, returnedValueType);
    }

    public String getSignature(AnnotationSymbol symbol, MethodSymbol methodSymbol) {
        String signatureTemplate = "```bsl\n%s &%s(%s)\n```";
        String annotationKind = this.getResourceString(ANNOTATION_KEY);
        String annotationName = symbol.getName();
        String parameters = this.getParametersSignatureDescription(methodSymbol);
        return String.format(signatureTemplate, annotationKind, annotationName, parameters);
    }

    public String getSignature(VariableSymbol symbol) {
        String signatureTemplate = "```bsl\n%s %s%s\n```";
        String varKey = this.getResourceString(VARIABLE_KEY);
        String name = symbol.getName();
        String export = symbol.isExport() ? " " + this.getResourceString(EXPORT_KEY) : "";
        return String.format(signatureTemplate, varKey, name, export);
    }

    public String getParametersSignatureDescription(MethodSymbol methodSymbol) {
        StringJoiner parametersDescription = new StringJoiner(", ");
        methodSymbol.getParameters().forEach(parameterDefinition -> {
            StringBuilder parameter = new StringBuilder();
            parameter.append(DescriptionFormatter.getAnnotationsDescriptionPart(parameterDefinition));
            String parameterName = parameterDefinition.getName();
            if (parameterDefinition.isByValue()) {
                parameter.append(this.getResourceString(VAL_KEY)).append(" ");
            }
            parameter.append(parameterName);
            String parameterTypes = parameterDefinition.getDescription().map(ParameterDescription::getTypes).map(DescriptionFormatter::getTypes).orElse("");
            if (!parameterTypes.isEmpty()) {
                parameter.append(": ").append(parameterTypes);
            }
            if (parameterDefinition.isOptional()) {
                parameter.append(" = ");
                parameter.append(parameterDefinition.getDefaultValue().value());
            }
            parametersDescription.add(parameter.toString());
        });
        return parametersDescription.toString();
    }

    private static String getAnnotationsDescriptionPart(ParameterDefinition parameterDefinition) {
        StringBuilder description = new StringBuilder();
        for (Annotation annotation : parameterDefinition.getAnnotations()) {
            description.append("&").append(annotation.getName()).append(" ");
        }
        return description.toString();
    }

    private static String getReturnedValueTypeDescriptionPart(MethodSymbol methodSymbol) {
        Object returnedValueType = methodSymbol.getDescription().map(MethodDescription::getReturnedValue).map(DescriptionFormatter::getTypes).orElse("");
        if (!((String)returnedValueType).isEmpty()) {
            returnedValueType = ": " + (String)returnedValueType;
        }
        return returnedValueType;
    }

    private static String getTypes(List<TypeDescription> typeDescriptions) {
        return typeDescriptions.stream().map(TypeDescription::getName).flatMap(parameterType -> Stream.of(parameterType.split(","))).map(String::trim).collect(Collectors.joining(" | "));
    }

    public String parameterToString(ParameterDescription parameterDescription, int level) {
        StringJoiner result = new StringJoiner("  \n");
        Map<String, String> typesMap = this.typesToMap(parameterDescription.getTypes(), level);
        String parameterTemplate = "  ".repeat(level) + PARAMETER_TEMPLATE;
        if (typesMap.size() == 1) {
            result.add(String.format(parameterTemplate, parameterDescription.getName(), DescriptionFormatter.typesMapToString(typesMap, 0)));
        } else {
            result.add(String.format(parameterTemplate, parameterDescription.getName(), ""));
            result.add(DescriptionFormatter.typesMapToString(typesMap, level + 1));
        }
        return result.toString();
    }

    public String parameterToString(ParameterDefinition parameterDefinition) {
        int level = 0;
        Optional<ParameterDescription> parameterDescription = parameterDefinition.getDescription();
        if (parameterDescription.isPresent()) {
            return this.parameterToString(parameterDescription.get(), level);
        }
        return String.format(PARAMETER_TEMPLATE, parameterDefinition.getName(), "");
    }

    private Map<String, String> typesToMap(List<TypeDescription> parameterTypes, int level) {
        HashMap<String, String> types = new HashMap<String, String>();
        parameterTypes.forEach(type -> {
            String typeDescription = this.typeToString((TypeDescription)type, level);
            String typeName = type.isHyperlink() ? String.format("[%s](%s)", type.getName(), type.getLink()) : String.format("`%s`", type.getName());
            types.merge(typeDescription, typeName, (oldValue, newValue) -> String.format("%s | %s", oldValue, newValue));
        });
        return types;
    }

    private static String typesMapToString(Map<String, String> types, int level) {
        StringJoiner result = new StringJoiner("  \n");
        String indent = "&nbsp;&nbsp;".repeat(level);
        types.forEach((key, value) -> {
            if (key.isBlank()) {
                result.add((CharSequence)value);
            } else {
                result.add(String.format("%s%s %s", indent, value, key));
            }
        });
        return result.toString();
    }

    private String typeToString(TypeDescription type, int level) {
        StringJoiner result = new StringJoiner("  \n");
        Object description = type.getDescription().replace("\n", "<br>" + "&nbsp;&nbsp;".repeat(level + 1));
        if (!((String)description).isBlank()) {
            description = "- " + (String)description;
        }
        if (!type.getParameters().isEmpty()) {
            description = (String)description + ":";
        }
        result.add((CharSequence)description);
        type.getParameters().forEach(parameter -> result.add(this.parameterToString((ParameterDescription)parameter, level + 1)));
        return result.toString();
    }

    private String getResourceString(String key) {
        return this.resources.getResourceString(this.getClass(), key);
    }

    @ConstructorProperties(value={"resources"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DescriptionFormatter(Resources resources) {
        this.resources = resources;
    }
}

