/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.hover;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.hover.DescriptionFormatter;
import com.github._1c_syntax.bsl.languageserver.hover.MarkupContentBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.StringJoiner;
import lombok.Generated;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public class MethodSymbolMarkupContentBuilder
implements MarkupContentBuilder<MethodSymbol> {
    private static final String PROCEDURE_KEY = "procedure";
    private static final String FUNCTION_KEY = "function";
    private static final String EXPORT_KEY = "export";
    private static final String VAL_KEY = "val";
    private static final String PARAMETERS_KEY = "parameters";
    private static final String RETURNED_VALUE_KEY = "returnedValue";
    private static final String EXAMPLES_KEY = "examples";
    private static final String CALL_OPTIONS_KEY = "callOptions";
    private static final String PARAMETER_TEMPLATE = "* **%s**: %s";
    private final DescriptionFormatter descriptionFormatter;

    @Override
    public MarkupContent getContent(MethodSymbol symbol) {
        StringJoiner markupBuilder = new StringJoiner("\n");
        String signature = this.descriptionFormatter.getSignature(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, signature);
        String methodLocation = this.descriptionFormatter.getLocation(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, methodLocation);
        String purposeSection = this.descriptionFormatter.getPurposeSection(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, purposeSection);
        String parametersSection = this.descriptionFormatter.getParametersSection(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, parametersSection);
        String returnedValueSection = this.descriptionFormatter.getReturnedValueSection(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, returnedValueSection);
        String examplesSection = this.descriptionFormatter.getExamplesSection(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, examplesSection);
        String callOptionsSection = this.descriptionFormatter.getCallOptionsSection(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, callOptionsSection);
        String content = markupBuilder.toString();
        return new MarkupContent("markdown", content);
    }

    @Override
    public SymbolKind getSymbolKind() {
        return SymbolKind.Method;
    }

    @ConstructorProperties(value={"descriptionFormatter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MethodSymbolMarkupContentBuilder(DescriptionFormatter descriptionFormatter) {
        this.descriptionFormatter = descriptionFormatter;
    }
}

