/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.codeactions.CodeActionSupplier;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

@Component
public final class CodeActionProvider {
    private final List<CodeActionSupplier> codeActionSuppliers;

    public static List<CodeAction> createCodeActions(List<TextEdit> textEdits, String title, URI uri, List<Diagnostic> diagnostics) {
        if (diagnostics.isEmpty()) {
            return Collections.emptyList();
        }
        WorkspaceEdit edit = new WorkspaceEdit();
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        changes.put(uri.toString(), textEdits);
        edit.setChanges(changes);
        if (diagnostics.size() > 1) {
            title = "Fix all: " + (String)title;
        }
        CodeAction codeAction = new CodeAction((String)title);
        codeAction.setDiagnostics(diagnostics);
        codeAction.setEdit(edit);
        codeAction.setKind("quickfix");
        if (diagnostics.size() == 1) {
            codeAction.setIsPreferred(Boolean.TRUE);
        }
        return Collections.singletonList(codeAction);
    }

    public List<Either<Command, CodeAction>> getCodeActions(CodeActionParams params, DocumentContext documentContext) {
        List only = Optional.ofNullable(params.getContext().getOnly()).orElse(Collections.emptyList());
        return this.codeActionSuppliers.stream().flatMap(codeActionSupplier -> codeActionSupplier.getCodeActions(params, documentContext).stream()).filter(codeAction -> only.isEmpty() || only.contains(codeAction.getKind())).map(Either::forRight).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"codeActionSuppliers"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CodeActionProvider(List<CodeActionSupplier> codeActionSuppliers) {
        this.codeActionSuppliers = codeActionSuppliers;
    }
}

