/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github._1c_syntax.bsl.languageserver.ClientCapabilitiesHolder;
import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensData;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.configuration.events.LanguageServerConfigurationChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensWorkspaceCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class CodeLensProvider {
    private final Map<String, CodeLensSupplier<CodeLensData>> codeLensSuppliersById;
    private final ObjectProvider<List<CodeLensSupplier<CodeLensData>>> enabledCodeLensSuppliersProvider;
    private final LanguageClientHolder clientHolder;
    private final ClientCapabilitiesHolder clientCapabilitiesHolder;
    private final ObjectMapper objectMapper;
    private List<CodeLensSupplier<CodeLensData>> enabledCodeLensSuppliers;

    @PostConstruct
    protected void init() {
        this.enabledCodeLensSuppliers = (List)this.enabledCodeLensSuppliersProvider.getObject();
    }

    public List<CodeLens> getCodeLens(DocumentContext documentContext) {
        return this.enabledCodeLensSuppliers.stream().filter(codeLensSupplier -> codeLensSupplier.isApplicable(documentContext)).map(codeLensSupplier -> codeLensSupplier.getCodeLenses(documentContext)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public CodeLens resolveCodeLens(DocumentContext documentContext, CodeLens unresolved, CodeLensData data) {
        CodeLensSupplier<CodeLensData> codeLensSupplier = this.codeLensSuppliersById.get(data.getId());
        CodeLens resolvedCodeLens = codeLensSupplier.resolve(documentContext, unresolved, data);
        resolvedCodeLens.setData(null);
        return resolvedCodeLens;
    }

    @EventListener
    public void handleEvent(LanguageServerConfigurationChangedEvent event) {
        this.enabledCodeLensSuppliers = (List)this.enabledCodeLensSuppliersProvider.getObject();
        this.refreshCodeLenses();
    }

    public CodeLensData extractData(CodeLens codeLens) {
        Object rawCodeLensData = codeLens.getData();
        if (rawCodeLensData instanceof CodeLensData) {
            return (CodeLensData)rawCodeLensData;
        }
        return (CodeLensData)this.objectMapper.readValue(rawCodeLensData.toString(), CodeLensData.class);
    }

    public void refreshCodeLenses() {
        boolean clientSupportsRefreshCodeLenses = this.clientCapabilitiesHolder.getCapabilities().map(ClientCapabilities::getWorkspace).map(WorkspaceClientCapabilities::getCodeLens).map(CodeLensWorkspaceCapabilities::getRefreshSupport).orElse(false);
        if (!clientSupportsRefreshCodeLenses) {
            return;
        }
        this.clientHolder.execIfConnected(LanguageClient::refreshCodeLenses);
    }

    @ConstructorProperties(value={"codeLensSuppliersById", "enabledCodeLensSuppliersProvider", "clientHolder", "clientCapabilitiesHolder", "objectMapper"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CodeLensProvider(Map<String, CodeLensSupplier<CodeLensData>> codeLensSuppliersById, ObjectProvider<List<CodeLensSupplier<CodeLensData>>> enabledCodeLensSuppliersProvider, LanguageClientHolder clientHolder, ClientCapabilitiesHolder clientCapabilitiesHolder, ObjectMapper objectMapper) {
        this.codeLensSuppliersById = codeLensSuppliersById;
        this.enabledCodeLensSuppliersProvider = enabledCodeLensSuppliersProvider;
        this.clientHolder = clientHolder;
        this.clientCapabilitiesHolder = clientCapabilitiesHolder;
        this.objectMapper = objectMapper;
    }
}

