/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.events.LanguageServerConfigurationChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public final class FormatProvider {
    private static final Set<Integer> keywordTypes = FormatProvider.keywordsTokenTypes();
    private static final Set<Integer> incrementIndentTokens = new HashSet<Integer>(Arrays.asList(6, 41, 42, 49, 50, 51, 55, 53, 59, 60));
    private static final Set<Integer> decrementIndentTokens = new HashSet<Integer>(Arrays.asList(7, 50, 51, 43, 44, 47, 48, 60, 61));
    private static final Set<Integer> primitiveTokenTypes = new HashSet<Integer>(Arrays.asList(33, 35, 34, 30, 31, 32, 36, 37));
    private final Map<Locale, Map<Integer, String>> keywordCanonText;
    private final LanguageServerConfiguration languageServerConfiguration;

    public FormatProvider(LanguageServerConfiguration languageServerConfiguration) {
        this.languageServerConfiguration = languageServerConfiguration;
        this.keywordCanonText = this.getKeywordsCanonicalText();
    }

    public List<TextEdit> getFormatting(DocumentFormattingParams params, DocumentContext documentContext) {
        List<Token> tokens = documentContext.getTokens();
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        Token firstToken = tokens.get(0);
        Token lastToken = tokens.get(tokens.size() - 1);
        Locale locale = documentContext.getScriptVariantLocale();
        return this.getTextEdits(tokens, locale, Ranges.create(firstToken, lastToken), firstToken.getCharPositionInLine(), params.getOptions());
    }

    public List<TextEdit> getRangeFormatting(DocumentRangeFormattingParams params, DocumentContext documentContext) {
        Position start = params.getRange().getStart();
        Position end = params.getRange().getEnd();
        int startLine = start.getLine() + 1;
        int startCharacter = start.getCharacter();
        int endLine = end.getLine() + 1;
        int endCharacter = end.getCharacter();
        List<Token> tokens = documentContext.getTokens().stream().filter(token -> {
            int tokenLine = token.getLine();
            int tokenCharacter = token.getCharPositionInLine();
            return FormatProvider.inLineRange(startLine, endLine, tokenLine) || tokenLine == endLine && FormatProvider.betweenStartAndStopCharacters(startCharacter, endCharacter, tokenCharacter);
        }).collect(Collectors.toList());
        return this.getTextEdits(tokens, documentContext.getScriptVariantLocale(), params.getRange(), startCharacter, params.getOptions());
    }

    @EventListener
    public void handleEvent(LanguageServerConfigurationChangedEvent event) {
        this.putLogicalNotOrKeywords(this.keywordCanonText);
    }

    private static boolean betweenStartAndStopCharacters(int startCharacter, int endCharacter, int tokenCharacter) {
        return tokenCharacter >= startCharacter && tokenCharacter < endCharacter;
    }

    private static boolean inLineRange(int startLine, int endLine, int tokenLine) {
        return tokenLine >= startLine && tokenLine < endLine;
    }

    private List<TextEdit> getTextEdits(List<Token> tokens, Locale languageLocale, Range range, int startCharacter, FormattingOptions options) {
        String newText = this.getNewText(tokens, languageLocale, range, startCharacter, options);
        if (newText.isEmpty()) {
            return Collections.emptyList();
        }
        TextEdit edit = new TextEdit(range, newText);
        return List.of(edit);
    }

    public String getNewText(List<Token> tokens, Locale languageLocale, Range range, int startCharacter, FormattingOptions options) {
        if (tokens.isEmpty()) {
            return "";
        }
        List<Token> filteredTokens = FormatProvider.filteredTokens(tokens);
        if (filteredTokens.isEmpty()) {
            return "";
        }
        int tabSize = options.getTabSize();
        boolean insertSpaces = options.isInsertSpaces();
        StringBuilder newTextBuilder = new StringBuilder();
        Token firstToken = filteredTokens.get(0);
        String indentation = insertSpaces ? StringUtils.repeat((char)' ', (int)tabSize) : "\t";
        int currentIndentLevel = (firstToken.getCharPositionInLine() - startCharacter) / indentation.length();
        int additionalIndentLevel = -1;
        boolean inMethodDefinition = false;
        boolean insideOperator = false;
        boolean parameterDeclarationMode = false;
        int lastLine = firstToken.getLine();
        int previousTokenType = -1;
        boolean previousIsUnary = false;
        for (Token token : filteredTokens) {
            String currentIndentation;
            boolean needNewLine;
            int tokenType = token.getType();
            boolean bl = needNewLine = token.getLine() != lastLine;
            if (tokenType == 42 || tokenType == 41) {
                inMethodDefinition = true;
            }
            if (inMethodDefinition && tokenType == 7) {
                inMethodDefinition = false;
            }
            switch (tokenType) {
                case 49: 
                case 50: 
                case 53: 
                case 55: {
                    insideOperator = true;
                    break;
                }
            }
            if (insideOperator) {
                switch (tokenType) {
                    case 52: 
                    case 54: {
                        insideOperator = false;
                        break;
                    }
                }
            }
            if (previousTokenType == 122 && tokenType == 6) {
                parameterDeclarationMode = true;
            }
            if (needNewLine) {
                currentIndentation = StringUtils.repeat((String)indentation, (int)currentIndentLevel);
                newTextBuilder.append(StringUtils.repeat((String)("\n" + currentIndentation), (int)(token.getLine() - lastLine - 1)));
            }
            if (needNewLine && tokenType == 3 && additionalIndentLevel < 0) {
                additionalIndentLevel = ++currentIndentLevel;
            }
            if (FormatProvider.needDecrementIndent(tokenType) && tokenType != 7 && --currentIndentLevel == additionalIndentLevel) {
                --currentIndentLevel;
                additionalIndentLevel = -1;
            }
            if (token.equals(firstToken)) {
                newTextBuilder.append(StringUtils.repeat((String)indentation, (int)currentIndentLevel));
            } else if (needNewLine) {
                currentIndentation = StringUtils.repeat((String)indentation, (int)currentIndentLevel);
                newTextBuilder.append("\n");
                newTextBuilder.append(currentIndentation);
            } else if (FormatProvider.needAddSpace(tokenType, previousTokenType, previousIsUnary)) {
                newTextBuilder.append(' ');
            }
            String addedText = token.getText();
            if (tokenType == 1) {
                addedText = addedText.trim();
            } else if (keywordTypes.contains(tokenType)) {
                addedText = this.checkAndFormatKeyword(token, languageLocale);
            }
            newTextBuilder.append(addedText);
            if (FormatProvider.needIncrementIndent(tokenType)) {
                ++currentIndentLevel;
            }
            if (tokenType == 11 && additionalIndentLevel < 0 && !inMethodDefinition && !insideOperator) {
                additionalIndentLevel = ++currentIndentLevel;
            }
            if (additionalIndentLevel > 0 && (tokenType == 9 || parameterDeclarationMode && FormatProvider.isPrimitive(tokenType))) {
                --currentIndentLevel;
                additionalIndentLevel = -1;
            }
            if (parameterDeclarationMode && tokenType == 7) {
                parameterDeclarationMode = false;
            }
            lastLine = token.getLine();
            previousIsUnary = FormatProvider.isUnary(tokenType, previousTokenType);
            previousTokenType = tokenType;
        }
        Token lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.getText().endsWith("\n") || lastToken.getText().endsWith("\r")) {
            newTextBuilder.append("\n");
            if (range.getEnd().getCharacter() != 0) {
                String currentIndentation = StringUtils.repeat((String)indentation, (int)currentIndentLevel);
                newTextBuilder.append(currentIndentation);
            }
        }
        return newTextBuilder.toString();
    }

    private String checkAndFormatKeyword(Token token, Locale languageLocale) {
        boolean needFormatKeyword = this.languageServerConfiguration.getFormattingOptions().isUseKeywordsFormatting();
        if (needFormatKeyword) {
            return this.keywordCanonText.get(languageLocale).getOrDefault(token.getType(), token.getText());
        }
        return token.getText();
    }

    private static List<Token> filteredTokens(List<Token> tokens) {
        return tokens.stream().filter(token -> token.getChannel() == 0 || token.getType() == 1).collect(Collectors.toList());
    }

    private static boolean needAddSpace(int type, int previousTokenType, boolean previousIsUnary) {
        if (previousIsUnary) {
            return false;
        }
        switch (previousTokenType) {
            case 3: 
            case 4: 
            case 23: 
            case 27: 
            case 29: {
                return false;
            }
            case 6: {
                return type == 10;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                return true;
            }
        }
        if (type == 6) {
            switch (previousTokenType) {
                case 22: 
                case 64: 
                case 69: 
                case 72: 
                case 76: 
                case 122: {
                    return false;
                }
            }
            return true;
        }
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    private static boolean isUnary(int type, int previousTokenType) {
        if (type != 13) {
            return false;
        }
        switch (previousTokenType) {
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 62: {
                return true;
            }
        }
        return false;
    }

    private static boolean needIncrementIndent(int tokenType) {
        return incrementIndentTokens.contains(tokenType);
    }

    private static boolean needDecrementIndent(int tokenType) {
        return decrementIndentTokens.contains(tokenType);
    }

    private static boolean isPrimitive(int tokenType) {
        return primitiveTokenTypes.contains(tokenType);
    }

    private static Set<Integer> keywordsTokenTypes() {
        HashSet<Integer> result = new HashSet<Integer>();
        result.add(49);
        result.add(52);
        result.add(50);
        result.add(51);
        result.add(47);
        result.add(55);
        result.add(57);
        result.add(58);
        result.add(56);
        result.add(53);
        result.add(54);
        result.add(48);
        result.add(41);
        result.add(42);
        result.add(44);
        result.add(43);
        result.add(65);
        result.add(70);
        result.add(62);
        result.add(71);
        result.add(63);
        result.add(68);
        result.add(67);
        result.add(66);
        result.add(59);
        result.add(60);
        result.add(64);
        result.add(61);
        result.add(69);
        result.add(73);
        result.add(74);
        result.add(75);
        result.add(126);
        result.add(46);
        result.add(72);
        result.add(45);
        return result;
    }

    private Map<Locale, Map<Integer, String>> getKeywordsCanonicalText() {
        HashMap<Locale, Map<Integer, String>> canonWords = new HashMap<Locale, Map<Integer, String>>();
        Locale ruLocale = Locale.forLanguageTag("ru");
        Locale enLocale = Locale.forLanguageTag("en");
        canonWords.put(ruLocale, new HashMap());
        canonWords.put(enLocale, new HashMap());
        ((Map)canonWords.get(ruLocale)).put(49, "\u0415\u0441\u043b\u0438");
        ((Map)canonWords.get(ruLocale)).put(52, "\u0422\u043e\u0433\u0434\u0430");
        ((Map)canonWords.get(ruLocale)).put(50, "\u0418\u043d\u0430\u0447\u0435\u0415\u0441\u043b\u0438");
        ((Map)canonWords.get(ruLocale)).put(51, "\u0418\u043d\u0430\u0447\u0435");
        ((Map)canonWords.get(ruLocale)).put(47, "\u041a\u043e\u043d\u0435\u0446\u0415\u0441\u043b\u0438");
        ((Map)canonWords.get(ruLocale)).put(55, "\u0414\u043b\u044f");
        ((Map)canonWords.get(ruLocale)).put(57, "\u041a\u0430\u0436\u0434\u043e\u0433\u043e");
        ((Map)canonWords.get(ruLocale)).put(58, "\u0418\u0437");
        ((Map)canonWords.get(ruLocale)).put(56, "\u041f\u043e");
        ((Map)canonWords.get(ruLocale)).put(53, "\u041f\u043e\u043a\u0430");
        ((Map)canonWords.get(ruLocale)).put(54, "\u0426\u0438\u043a\u043b");
        ((Map)canonWords.get(ruLocale)).put(48, "\u041a\u043e\u043d\u0435\u0446\u0426\u0438\u043a\u043b\u0430");
        ((Map)canonWords.get(ruLocale)).put(41, "\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430");
        ((Map)canonWords.get(ruLocale)).put(42, "\u0424\u0443\u043d\u043a\u0446\u0438\u044f");
        ((Map)canonWords.get(ruLocale)).put(44, "\u041a\u043e\u043d\u0435\u0446\u0424\u0443\u043d\u043a\u0446\u0438\u0438");
        ((Map)canonWords.get(ruLocale)).put(43, "\u041a\u043e\u043d\u0435\u0446\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b");
        ((Map)canonWords.get(ruLocale)).put(65, "\u041f\u0435\u0440\u0435\u043c");
        ((Map)canonWords.get(ruLocale)).put(70, "\u041f\u0435\u0440\u0435\u0439\u0442\u0438");
        ((Map)canonWords.get(ruLocale)).put(62, "\u0412\u043e\u0437\u0432\u0440\u0430\u0442");
        ((Map)canonWords.get(ruLocale)).put(71, "\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c");
        ((Map)canonWords.get(ruLocale)).put(63, "\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c");
        ((Map)canonWords.get(ruLocale)).put(68, "\u0418");
        ((Map)canonWords.get(ruLocale)).put(59, "\u041f\u043e\u043f\u044b\u0442\u043a\u0430");
        ((Map)canonWords.get(ruLocale)).put(60, "\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
        ((Map)canonWords.get(ruLocale)).put(64, "\u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
        ((Map)canonWords.get(ruLocale)).put(61, "\u041a\u043e\u043d\u0435\u0446\u041f\u043e\u043f\u044b\u0442\u043a\u0438");
        ((Map)canonWords.get(ruLocale)).put(69, "\u041d\u043e\u0432\u044b\u0439");
        ((Map)canonWords.get(ruLocale)).put(73, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a");
        ((Map)canonWords.get(ruLocale)).put(74, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a");
        ((Map)canonWords.get(ruLocale)).put(75, "\u0410\u0441\u0438\u043d\u0445");
        ((Map)canonWords.get(ruLocale)).put(126, "\u0416\u0434\u0430\u0442\u044c");
        ((Map)canonWords.get(ruLocale)).put(46, "\u0417\u043d\u0430\u0447");
        ((Map)canonWords.get(ruLocale)).put(72, "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c");
        ((Map)canonWords.get(ruLocale)).put(45, "\u042d\u043a\u0441\u043f\u043e\u0440\u0442");
        ((Map)canonWords.get(enLocale)).put(49, "If");
        ((Map)canonWords.get(enLocale)).put(52, "Then");
        ((Map)canonWords.get(enLocale)).put(50, "ElsIf");
        ((Map)canonWords.get(enLocale)).put(51, "Else");
        ((Map)canonWords.get(enLocale)).put(47, "EndIf");
        ((Map)canonWords.get(enLocale)).put(55, "For");
        ((Map)canonWords.get(enLocale)).put(57, "Each");
        ((Map)canonWords.get(enLocale)).put(58, "In");
        ((Map)canonWords.get(enLocale)).put(56, "To");
        ((Map)canonWords.get(enLocale)).put(53, "While");
        ((Map)canonWords.get(enLocale)).put(54, "Do");
        ((Map)canonWords.get(enLocale)).put(48, "EndDo");
        ((Map)canonWords.get(enLocale)).put(41, "Procedure");
        ((Map)canonWords.get(enLocale)).put(42, "Function");
        ((Map)canonWords.get(enLocale)).put(44, "EndFunction");
        ((Map)canonWords.get(enLocale)).put(43, "EndProcedure");
        ((Map)canonWords.get(enLocale)).put(65, "Var");
        ((Map)canonWords.get(enLocale)).put(70, "Goto");
        ((Map)canonWords.get(enLocale)).put(62, "Return");
        ((Map)canonWords.get(enLocale)).put(71, "Break");
        ((Map)canonWords.get(enLocale)).put(63, "Continue");
        ((Map)canonWords.get(enLocale)).put(68, "And");
        ((Map)canonWords.get(enLocale)).put(59, "Try");
        ((Map)canonWords.get(enLocale)).put(60, "Except");
        ((Map)canonWords.get(enLocale)).put(64, "Raise");
        ((Map)canonWords.get(enLocale)).put(61, "EndTry");
        ((Map)canonWords.get(enLocale)).put(69, "New");
        ((Map)canonWords.get(enLocale)).put(73, "AddHandler");
        ((Map)canonWords.get(enLocale)).put(74, "RemoveHandler");
        ((Map)canonWords.get(enLocale)).put(75, "Async");
        ((Map)canonWords.get(enLocale)).put(126, "Await");
        ((Map)canonWords.get(enLocale)).put(46, "Val");
        ((Map)canonWords.get(enLocale)).put(72, "Execute");
        ((Map)canonWords.get(enLocale)).put(45, "Export");
        this.putLogicalNotOrKeywords(canonWords);
        return canonWords;
    }

    private void putLogicalNotOrKeywords(Map<Locale, Map<Integer, String>> canonWords) {
        String andKeywordCanonTextEng;
        String notKeywordCanonTextEng;
        String notKeywordCanonTextRu;
        String orKeywordCanonTextEng;
        String orKeywordCanonTextRu;
        Locale ruLocale = Locale.forLanguageTag("ru");
        Locale enLocale = Locale.forLanguageTag("en");
        boolean useUppercaseForLogicalOrNotAndKeywords = this.languageServerConfiguration.getFormattingOptions().isUseUpperCaseForOrNotAndKeywords();
        if (useUppercaseForLogicalOrNotAndKeywords) {
            orKeywordCanonTextRu = "\u0418\u041b\u0418";
            orKeywordCanonTextEng = "OR";
            notKeywordCanonTextRu = "\u041d\u0415";
            notKeywordCanonTextEng = "NOT";
            andKeywordCanonTextEng = "AND";
        } else {
            orKeywordCanonTextRu = "\u0418\u043b\u0438";
            orKeywordCanonTextEng = "Or";
            notKeywordCanonTextRu = "\u041d\u0435";
            notKeywordCanonTextEng = "Not";
            andKeywordCanonTextEng = "And";
        }
        canonWords.get(ruLocale).put(67, orKeywordCanonTextRu);
        canonWords.get(ruLocale).put(66, notKeywordCanonTextRu);
        canonWords.get(enLocale).put(67, orKeywordCanonTextEng);
        canonWords.get(enLocale).put(66, notKeywordCanonTextEng);
        canonWords.get(enLocale).put(68, andKeywordCanonTextEng);
    }
}

