/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceResolver;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ReferenceParams;
import org.springframework.stereotype.Component;

@Component
public class ReferencesProvider {
    private final ReferenceResolver referenceResolver;
    private final ReferenceIndex referenceIndex;

    public List<Location> getReferences(DocumentContext documentContext, ReferenceParams params) {
        Position position = params.getPosition();
        return this.referenceResolver.findReference(documentContext.getUri(), position).flatMap(Reference::getSourceDefinedSymbol).stream().map(this.referenceIndex::getReferencesTo).flatMap(Collection::stream).map(Reference::toLocation).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"referenceResolver", "referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReferencesProvider(ReferenceResolver referenceResolver, ReferenceIndex referenceIndex) {
        this.referenceResolver = referenceResolver;
        this.referenceIndex = referenceIndex;
    }
}

