/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.recognizer;

import com.github._1c_syntax.bsl.languageserver.recognizer.AbstractDetector;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ContainsDetector
extends AbstractDetector {
    private final List<String> searchWords;

    public ContainsDetector(double probability, String ... searchWords) {
        super(probability);
        this.searchWords = Arrays.asList(searchWords);
    }

    @Override
    public int scan(String line) {
        String lineWithoutWhitespaces = StringUtils.deleteWhitespace((String)line);
        int matchers = 0;
        for (String str : this.searchWords) {
            matchers += StringUtils.countMatches((CharSequence)lineWithoutWhitespaces, (CharSequence)str);
        }
        return matchers;
    }
}

