/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.lsp4j.Diagnostic;

public class CodeQualityReportEntry {
    private static final Map<DiagnosticSeverity, Severity> SEVERITY_MAP = Map.of(DiagnosticSeverity.BLOCKER, Severity.BLOCKER, DiagnosticSeverity.CRITICAL, Severity.CRITICAL, DiagnosticSeverity.MAJOR, Severity.MAJOR, DiagnosticSeverity.MINOR, Severity.MINOR, DiagnosticSeverity.INFO, Severity.INFO);
    private final String description;
    @JsonProperty(value="check_name")
    private final String checkName;
    private final String fingerprint;
    private final Severity severity;
    private final Location location;

    public CodeQualityReportEntry(String path, Diagnostic diagnostic, DiagnosticInfo diagnosticInfo) {
        this.description = diagnostic.getMessage();
        this.checkName = diagnosticInfo.getCode().getStringValue();
        String fingerprintData = path + "//" + this.checkName + "//" + String.valueOf(diagnostic.getRange());
        this.fingerprint = DigestUtils.sha256Hex((String)fingerprintData);
        this.severity = SEVERITY_MAP.get((Object)diagnosticInfo.getSeverity());
        this.location = new Location();
        this.location.path = path;
        this.location.lines = new Lines();
        this.location.lines.begin = diagnostic.getRange().getStart().getLine() + 1;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCheckName() {
        return this.checkName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Severity getSeverity() {
        return this.severity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Location getLocation() {
        return this.location;
    }

    @ConstructorProperties(value={"description", "checkName", "fingerprint", "severity", "location"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CodeQualityReportEntry(String description, String checkName, String fingerprint, Severity severity, Location location) {
        this.description = description;
        this.checkName = checkName;
        this.fingerprint = fingerprint;
        this.severity = severity;
        this.location = location;
    }

    public static enum Severity {
        BLOCKER,
        CRITICAL,
        MAJOR,
        MINOR,
        INFO;

    }

    public static class Location {
        private String path;
        private Lines lines;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getPath() {
            return this.path;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Lines getLines() {
            return this.lines;
        }

        @ConstructorProperties(value={"path", "lines"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Location(String path, Lines lines) {
            this.path = path;
            this.lines = lines;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Location() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CodeQualityReportEntry.Location(path=" + this.getPath() + ", lines=" + String.valueOf(this.getLines()) + ")";
        }
    }

    public static class Lines {
        private int begin;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getBegin() {
            return this.begin;
        }

        @ConstructorProperties(value={"begin"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Lines(int begin) {
            this.begin = begin;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Lines() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CodeQualityReportEntry.Lines(begin=" + this.getBegin() + ")";
        }
    }
}

