/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.contrastsecurity.sarif.ArtifactLocation;
import com.contrastsecurity.sarif.ConfigurationOverride;
import com.contrastsecurity.sarif.Invocation;
import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.Message;
import com.contrastsecurity.sarif.MultiformatMessageString;
import com.contrastsecurity.sarif.PhysicalLocation;
import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.ReportingConfiguration;
import com.contrastsecurity.sarif.ReportingDescriptor;
import com.contrastsecurity.sarif.ReportingDescriptorReference;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.contrastsecurity.sarif.Tool;
import com.contrastsecurity.sarif.ToolComponent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.DiagnosticsOptions;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.DiagnosticReporter;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.data.FileInfo;
import com.github._1c_syntax.utils.Absolute;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SarifReporter
implements DiagnosticReporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SarifReporter.class);
    private static final Map<DiagnosticSeverity, Result.Level> severityToResultLevel = Map.of(DiagnosticSeverity.Error, Result.Level.ERROR, DiagnosticSeverity.Warning, Result.Level.WARNING, DiagnosticSeverity.Information, Result.Level.NOTE, DiagnosticSeverity.Hint, Result.Level.NONE);
    private static final Map<DiagnosticSeverity, ReportingConfiguration.Level> severityToReportLevel = Map.of(DiagnosticSeverity.Error, ReportingConfiguration.Level.ERROR, DiagnosticSeverity.Warning, ReportingConfiguration.Level.WARNING, DiagnosticSeverity.Information, ReportingConfiguration.Level.NOTE, DiagnosticSeverity.Hint, ReportingConfiguration.Level.NONE);
    private final LanguageServerConfiguration configuration;
    private final Collection<DiagnosticInfo> diagnosticInfos;
    private final ServerInfo serverInfo;

    @Override
    public String key() {
        return "sarif";
    }

    @Override
    public void report(AnalysisInfo analysisInfo, Path outputDir) {
        SarifSchema210 report = this.createReport(analysisInfo);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File reportFile = new File(outputDir.toFile(), "./bsl-ls.sarif");
        mapper.writeValue(reportFile, (Object)report);
        LOGGER.info("SARIF report saved to {}", (Object)reportFile.getAbsolutePath());
    }

    private SarifSchema210 createReport(AnalysisInfo analysisInfo) {
        URI schema = URI.create("https://json.schemastore.org/sarif-2.1.0.json");
        Run run = this.createRun(analysisInfo);
        return new SarifSchema210().with$schema(schema).withVersion(SarifSchema210.Version._2_1_0).withRuns(List.of(run));
    }

    private Run createRun(AnalysisInfo analysisInfo) {
        Tool tool = this.createTool();
        Invocation invocation = this.createInvocation();
        List<Result> results = SarifReporter.createResults(analysisInfo);
        return new Run().withTool(tool).withInvocations(List.of(invocation)).withLanguage(this.configuration.getLanguage().getLanguageCode()).withDefaultEncoding("UTF-8").withDefaultSourceLanguage("BSL").withResults(results);
    }

    private Invocation createInvocation() {
        HashSet ruleConfigurationOverrides = new HashSet();
        DiagnosticsOptions diagnosticsOptions = this.configuration.getDiagnosticsOptions();
        diagnosticsOptions.getParameters().forEach((key, option) -> {
            ReportingDescriptorReference descriptor = new ReportingDescriptorReference().withId(key);
            ConfigurationOverride configurationOverride = new ConfigurationOverride().withDescriptor(descriptor);
            ReportingConfiguration reportingConfiguration = new ReportingConfiguration();
            if (option.isLeft()) {
                reportingConfiguration.setEnabled((Boolean)option.getLeft());
            } else {
                PropertyBag parameters = new PropertyBag();
                Map diagnosticParameters = (Map)option.getRight();
                diagnosticParameters.forEach((arg_0, arg_1) -> ((PropertyBag)parameters).setAdditionalProperty(arg_0, arg_1));
                reportingConfiguration.setParameters(parameters);
            }
            configurationOverride.withConfiguration(reportingConfiguration);
            ruleConfigurationOverrides.add(configurationOverride);
        });
        ArtifactLocation workingDirectory = new ArtifactLocation().withUri(Absolute.uri((URI)new File(".").toURI()).toString());
        return new Invocation().withExecutionSuccessful(Boolean.valueOf(true)).withRuleConfigurationOverrides(ruleConfigurationOverrides).withWorkingDirectory(workingDirectory).withProcessId(Integer.valueOf((int)ProcessHandle.current().pid()));
    }

    private Tool createTool() {
        String name = this.serverInfo.getName();
        String organization = "1c-syntax";
        String version = this.serverInfo.getVersion();
        URI informationUri = URI.create(this.configuration.getSiteRoot());
        String language = this.configuration.getLanguage().getLanguageCode();
        Set rules = this.diagnosticInfos.stream().map(SarifReporter::createReportingDescriptor).collect(Collectors.toSet());
        ToolComponent driver = new ToolComponent().withName(name).withOrganization(organization).withVersion(version).withInformationUri(informationUri).withLanguage(language).withRules(rules);
        return new Tool().withDriver(driver);
    }

    private static ReportingDescriptor createReportingDescriptor(DiagnosticInfo diagnosticInfo) {
        String id = diagnosticInfo.getCode().getStringValue();
        String name = diagnosticInfo.getName();
        MultiformatMessageString fullDescription = new MultiformatMessageString().withText(diagnosticInfo.getDescription()).withMarkdown(diagnosticInfo.getDescription());
        URI helpUri = URI.create(diagnosticInfo.getDiagnosticCodeDescriptionHref());
        PropertyBag parameters = new PropertyBag();
        diagnosticInfo.getParameters().forEach(parameterInfo -> parameters.withAdditionalProperty(parameterInfo.getName(), parameterInfo.getDefaultValue()));
        ReportingConfiguration defaultConfiguration = new ReportingConfiguration().withEnabled(Boolean.valueOf(diagnosticInfo.isActivatedByDefault())).withLevel(severityToReportLevel.get(diagnosticInfo.getLSPSeverity())).withParameters(parameters);
        Set tags = diagnosticInfo.getTags().stream().map(Enum::name).collect(Collectors.toSet());
        PropertyBag properties = new PropertyBag().withTags(tags);
        return new ReportingDescriptor().withId(id).withName(name).withFullDescription(fullDescription).withHelpUri(helpUri).withDefaultConfiguration(defaultConfiguration).withProperties(properties);
    }

    private static List<Result> createResults(AnalysisInfo analysisInfo) {
        ArrayList<Result> results = new ArrayList<Result>();
        analysisInfo.getFileinfos().forEach(fileInfo -> fileInfo.getDiagnostics().stream().map(diagnostic -> SarifReporter.createResult(fileInfo, diagnostic)).collect(Collectors.toCollection(() -> results)));
        return results;
    }

    private static Result createResult(FileInfo fileInfo, Diagnostic diagnostic) {
        String uri = Absolute.uri((URI)fileInfo.getPath().toUri()).toString();
        Message message = new Message().withText(diagnostic.getMessage());
        String ruleId = DiagnosticCode.getStringValue((Either<String, Integer>)diagnostic.getCode());
        Result.Level level = severityToResultLevel.get(diagnostic.getSeverity());
        ArtifactLocation analysisTarget = new ArtifactLocation().withUri(uri);
        List<Location> locations = List.of(SarifReporter.createLocation(diagnostic.getMessage(), uri, diagnostic.getRange()));
        Set relatedLocations = Optional.ofNullable(diagnostic.getRelatedInformation()).stream().flatMap(Collection::stream).skip(1L).map(relatedInformation -> SarifReporter.createLocation(relatedInformation.getMessage(), relatedInformation.getLocation().getUri(), relatedInformation.getLocation().getRange())).collect(Collectors.toSet());
        return new Result().withMessage(message).withRuleId(ruleId).withLevel(level).withAnalysisTarget(analysisTarget).withLocations(locations).withRelatedLocations(relatedLocations);
    }

    private static Location createLocation(String messageString, String uri, Range range) {
        Message message = new Message().withText(messageString);
        ArtifactLocation artifactLocation = new ArtifactLocation().withUri(uri);
        Region region = new Region().withStartLine(Integer.valueOf(range.getStart().getLine() + 1)).withStartColumn(Integer.valueOf(range.getStart().getCharacter() + 1)).withEndLine(Integer.valueOf(range.getEnd().getLine() + 1)).withEndColumn(Integer.valueOf(range.getEnd().getCharacter() + 1));
        PhysicalLocation physicalLocation = new PhysicalLocation().withArtifactLocation(artifactLocation).withRegion(region);
        return new Location().withMessage(message).withPhysicalLocation(physicalLocation);
    }

    @ConstructorProperties(value={"configuration", "diagnosticInfos", "serverInfo"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SarifReporter(LanguageServerConfiguration configuration, Collection<DiagnosticInfo> diagnosticInfos, ServerInfo serverInfo) {
        this.configuration = configuration;
        this.diagnosticInfos = diagnosticInfos;
        this.serverInfo = serverInfo;
    }
}

