/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils.expressiontree;

import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.AbstractCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslExpression;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TernaryOperatorNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.UnaryOperationNode;

public class ExpressionTreeVisitor {
    private void visit(BslExpression node) {
        switch (node.getNodeType()) {
            case CALL: {
                this.visitAbstractCall((AbstractCallNode)node);
                break;
            }
            case UNARY_OP: {
                this.visitUnaryOperation((UnaryOperationNode)node);
                break;
            }
            case TERNARY_OP: {
                TernaryOperatorNode ternary = (TernaryOperatorNode)node;
                this.visitTernaryOperator(ternary);
                break;
            }
            case BINARY_OP: {
                this.visitBinaryOperation((BinaryOperationNode)node);
                break;
            }
        }
    }

    protected void visitTopLevelExpression(BslExpression node) {
        this.visit(node);
    }

    protected void visitAbstractCall(AbstractCallNode node) {
        for (BslExpression expr : node.arguments()) {
            this.visit(expr);
        }
    }

    protected void visitUnaryOperation(UnaryOperationNode node) {
        this.visit(node.getOperand());
    }

    protected void visitBinaryOperation(BinaryOperationNode node) {
        this.visit(node.getLeft());
        this.visit(node.getRight());
    }

    protected void visitTernaryOperator(TernaryOperatorNode node) {
        this.visit(node.getCondition());
        this.visit(node.getTruePart());
        this.visit(node.getFalsePart());
    }
}

