/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.websocket;

import jakarta.websocket.server.ServerEndpointConfig;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.websocket.jakarta.WebSocketEndpoint;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

@Configuration
@ConditionalOnWebApplication
@EnableWebSocket
public class WebSocketConfiguration {
    @Value(value="${app.websocket.lsp-path}")
    private String endpointPath = "";

    @Bean
    public ServerEndpointConfig serverEndpointConfig(WebSocketEndpoint<LanguageClient> endpoint) {
        return new ServerEndpointRegistration(this.endpointPath, endpoint);
    }

    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }
}

